/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.testutils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTestService {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTestService.class);
    private static final int CONNECTION_TIMEOUT_MS = 30000;
    private static final String BIND_HOST = "127.0.0.1";
    private static final int HS2_THRIFT_PORT = 9999;
    public static final String HS2_JDBC_URL = String.format("jdbc:hive2://%s:%s/", "127.0.0.1", 9999);
    private final Configuration hadoopConf;
    private final String workDir;
    private final Map<String, String> sysProps = new HashMap<String, String>();
    private ExecutorService executorService;
    private TServer tServer;
    private HiveServer2 hiveServer;
    private HiveConf hiveConf;

    public HiveTestService(Configuration hadoopConf) throws IOException {
        this.workDir = Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]).toFile().getAbsolutePath();
        this.hadoopConf = hadoopConf;
    }

    public HiveServer2 start() throws IOException {
        Objects.requireNonNull(this.workDir, "The work dir must be set before starting cluster.");
        String localHiveLocation = HiveTestService.getHiveLocation(this.workDir);
        LOG.info("Cleaning Hive cluster data at: " + localHiveLocation + " and starting fresh.");
        File file = new File(localHiveLocation);
        FileIOUtils.deleteDirectory((File)file);
        this.hiveConf = this.configureHive(this.hadoopConf, localHiveLocation);
        this.executorService = Executors.newSingleThreadExecutor();
        this.tServer = this.startMetaStore(this.hiveConf);
        this.hiveServer = this.startHiveServer(this.hiveConf);
        if (!this.waitForServerUp(this.hiveConf)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        LOG.info("Hive Minicluster service started.");
        return this.hiveServer;
    }

    public void stop() {
        this.resetSystemProperties();
        if (this.tServer != null) {
            try {
                this.tServer.stop();
            }
            catch (Exception e) {
                LOG.error("Stop meta store failed", (Throwable)e);
            }
        }
        if (this.hiveServer != null) {
            try {
                this.hiveServer.stop();
            }
            catch (Exception e) {
                LOG.error("Stop hive server failed", (Throwable)e);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        LOG.info("Hive Minicluster service shut down.");
        this.tServer = null;
        this.hiveServer = null;
    }

    public HiveServer2 getHiveServer() {
        return this.hiveServer;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public int getHiveServerPort() {
        return this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
    }

    public String getJdbcHive2Url() {
        return String.format("jdbc:hive2://%s:%s/", this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST), this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT));
    }

    public HiveConf configureHive(Configuration hadoopConf, String localHiveLocation) throws IOException {
        hadoopConf.set("hive.metastore.local", "false");
        hadoopConf.set("datanucleus.schema.autoCreateTables", "true");
        hadoopConf.set("datanucleus.autoCreateSchema", "true");
        hadoopConf.set("datanucleus.fixedDatastore", "false");
        HiveConf conf = new HiveConf(hadoopConf, HiveConf.class);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        conf.setBoolVar(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION, false);
        int hs2ThriftPort = hadoopConf.getInt(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, 9999);
        conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, hs2ThriftPort);
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, BIND_HOST);
        int metastoreServerPort = hadoopConf.getInt(HiveConf.ConfVars.METASTORE_SERVER_PORT.varname, NetworkTestUtils.nextFreePort());
        conf.setIntVar(HiveConf.ConfVars.METASTORE_SERVER_PORT, metastoreServerPort);
        conf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://127.0.0.1:" + metastoreServerPort);
        File localHiveDir = new File(localHiveLocation);
        localHiveDir.mkdirs();
        File metastoreDbDir = new File(localHiveDir, "metastore_db");
        conf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, "jdbc:derby:" + metastoreDbDir.getPath() + ";create=true");
        File derbyLogFile = new File(localHiveDir, "derby.log");
        derbyLogFile.createNewFile();
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
        this.setSystemProperty("derby.system.home", localHiveDir.getAbsolutePath());
        File metastoreWarehouseDir = new File(localHiveDir, "warehouse");
        metastoreWarehouseDir.mkdir();
        conf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, metastoreWarehouseDir.getAbsolutePath());
        return conf;
    }

    private boolean waitForServerUp(HiveConf serverConf) {
        LOG.info("waiting for " + serverConf.getVar(HiveConf.ConfVars.METASTOREURIS));
        long start = System.currentTimeMillis();
        while (true) {
            try {
                new HiveMetaStoreClient(serverConf);
                return true;
            }
            catch (MetaException metaException) {
                if (System.currentTimeMillis() <= start + 30000L) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                return false;
            }
            break;
        }
    }

    private void setSystemProperty(String name, String value) {
        if (!this.sysProps.containsKey(name)) {
            String currentValue = System.getProperty(name);
            this.sysProps.put(name, currentValue);
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.getProperties().remove(name);
        }
    }

    private void resetSystemProperties() {
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.getProperties().remove(entry.getKey());
        }
        this.sysProps.clear();
    }

    private static String getHiveLocation(String baseLocation) {
        return baseLocation + "/" + "hive";
    }

    private HiveServer2 startHiveServer(HiveConf serverConf) {
        HiveServer2 hiveServer = new HiveServer2();
        hiveServer.init(serverConf);
        hiveServer.start();
        return hiveServer;
    }

    private TServer startMetaStore(HiveConf conf) throws IOException {
        try {
            TUGIBasedProcessor processor;
            ChainedTTransportFactory transFactory;
            String host = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            int port = conf.getIntVar(HiveConf.ConfVars.METASTORE_SERVER_PORT);
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useFramedTransport = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
            InetSocketAddress address = new InetSocketAddress(host, port);
            TServerSocketKeepAlive serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(address) : new TServerSocket(address);
            HiveMetaStore.HMSHandler baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", conf, false);
            IHMSHandler handler = RetryingHMSHandler.getProxy((HiveConf)conf, (IHMSHandler)baseHandler, (boolean)true);
            if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                transFactory = useFramedTransport ? new ChainedTTransportFactory((TTransportFactory)new TFramedTransport.Factory(), (TTransportFactory)new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                processor = new TUGIBasedProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info("Starting DB backed MetaStore Server with SetUGI enabled");
            } else {
                transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                processor = new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info("Starting DB backed MetaStore Server");
            }
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).transportFactory((TTransportFactory)transFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            this.executorService.submit(() -> ((TServer)tServer).serve());
            return tServer;
        }
        catch (Throwable x) {
            throw new IOException(x);
        }
    }

    private static final class TServerSocketKeepAlive
    extends TServerSocket {
        public TServerSocketKeepAlive(int port) throws TTransportException {
            super(port, 0);
        }

        public TServerSocketKeepAlive(InetSocketAddress address) throws TTransportException {
            super(address, 0);
        }

        protected TSocket acceptImpl() throws TTransportException {
            TSocket ts = super.acceptImpl();
            try {
                ts.getSocket().setKeepAlive(true);
            }
            catch (SocketException e) {
                throw new TTransportException((Throwable)e);
            }
            return ts;
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

