/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalHiveSyncTool
extends HiveSyncTool {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalHiveSyncTool.class);
    protected final GlobalHiveSyncConfig config;

    public GlobalHiveSyncTool(Properties props, Configuration hadoopConf) {
        super(props, hadoopConf);
        this.config = new GlobalHiveSyncConfig(props, hadoopConf);
    }

    @Override
    public void syncHoodieTable() {
        this.doSync();
    }

    @Override
    protected void syncHoodieTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized) {
        super.syncHoodieTable(tableName, useRealtimeInputFormat, readAsOptimized);
        Option timestamp = Option.ofNullable((Object)this.config.getString(GlobalHiveSyncConfig.META_SYNC_GLOBAL_REPLICATE_TIMESTAMP));
        if (timestamp.isPresent()) {
            this.syncClient.updateLastReplicatedTimeStamp(tableName, (String)timestamp.get());
            LOG.info("Sync complete for {}", (Object)tableName);
        } else {
            LOG.warn("Sync skipped: {} is not set.", (Object)GlobalHiveSyncConfig.META_SYNC_GLOBAL_REPLICATE_TIMESTAMP.key());
        }
    }

    public Map<String, Option<String>> getLastReplicatedTimeStampMap() {
        HashMap<String, Option<String>> timeStampMap = new HashMap<String, Option<String>>();
        Option timeStamp = this.syncClient.getLastReplicatedTime(this.snapshotTableName);
        timeStampMap.put(this.snapshotTableName, timeStamp);
        if (HoodieTableType.MERGE_ON_READ.equals((Object)this.syncClient.getTableType())) {
            Option roTimeStamp = this.syncClient.getLastReplicatedTime((String)this.roTableName.get());
            timeStampMap.put((String)this.roTableName.get(), (Option<String>)roTimeStamp);
        }
        return timeStampMap;
    }

    public void setLastReplicatedTimeStamp(Map<String, Option<String>> timeStampMap) {
        for (String tableName : timeStampMap.keySet()) {
            Option<String> timestamp = timeStampMap.get(tableName);
            if (timestamp.isPresent()) {
                this.syncClient.updateLastReplicatedTimeStamp(tableName, (String)timestamp.get());
                LOG.info("updated timestamp for " + tableName + " to: " + (String)timestamp.get());
                continue;
            }
            this.syncClient.deleteLastReplicatedTimeStamp(tableName);
            LOG.info("deleted timestamp for " + tableName);
        }
    }
}

