/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommit;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommitParams;
import org.apache.hudi.hive.replication.ReplicationStateSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSyncGlobalCommitTool
implements HiveSyncGlobalCommit,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSyncGlobalCommitTool.class);
    private final HiveSyncGlobalCommitParams params;
    private final List<ReplicationStateSync> replicationStateSyncList;

    ReplicationStateSync getReplicatedState(boolean forRemote) {
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(new Path(this.params.loadedProps.getProperty(forRemote ? HiveSyncGlobalCommitParams.REMOTE_HIVE_SITE_URI : HiveSyncGlobalCommitParams.LOCAL_HIVE_SITE_URI)));
        ReplicationStateSync state = new ReplicationStateSync(this.params.mkGlobalHiveSyncProps(forRemote), hiveConf, forRemote ? "REMOTESYNC" : "LOCALSYNC");
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() {
        String name = Thread.currentThread().getName();
        try {
            for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
                Thread.currentThread().setName(stateSync.getClusterId());
                LOG.info("starting sync for state " + stateSync);
                stateSync.sync();
                LOG.info("synced state " + stateSync);
            }
        }
        catch (Exception e) {
            Thread.currentThread().setName(name);
            LOG.error(String.format("Error while trying to commit replication state %s", e.getMessage()), (Throwable)e);
            boolean stateSync = false;
            return stateSync;
        }
        finally {
            Thread.currentThread().setName(name);
        }
        LOG.info("done syncing to all tables, verifying the timestamps...");
        ReplicationStateSync base = this.replicationStateSyncList.get(0);
        boolean success = true;
        LOG.info("expecting all timestamps to be similar to: " + base);
        for (int idx = 1; idx < this.replicationStateSyncList.size(); ++idx) {
            ReplicationStateSync other = this.replicationStateSyncList.get(idx);
            if (base.replicationStateIsInSync(other)) continue;
            LOG.error("the timestamp of other : " + other + " is not matching with base: " + base);
            success = false;
        }
        return success;
    }

    @Override
    public boolean rollback() {
        for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
            stateSync.rollback();
        }
        return true;
    }

    public HiveSyncGlobalCommitTool(HiveSyncGlobalCommitParams params) {
        this.params = params;
        this.replicationStateSyncList = new ArrayList<ReplicationStateSync>(2);
        this.replicationStateSyncList.add(this.getReplicatedState(false));
        this.replicationStateSyncList.add(this.getReplicatedState(true));
    }

    private static HiveSyncGlobalCommitParams loadParams(String[] args) throws IOException {
        HiveSyncGlobalCommitParams params = new HiveSyncGlobalCommitParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        params.load();
        return params;
    }

    @Override
    public void close() {
        for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
            stateSync.close();
        }
    }

    public static void main(String[] args) throws IOException, HoodieHiveSyncException {
        HiveSyncGlobalCommitParams params = HiveSyncGlobalCommitTool.loadParams(args);
        try (HiveSyncGlobalCommitTool globalCommitTool = new HiveSyncGlobalCommitTool(params);){
            boolean success = globalCommitTool.commit();
            if (!success && !globalCommitTool.rollback()) {
                throw new RuntimeException("not able to rollback failed commit");
            }
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("not able to commit replicated timestamp", e);
        }
    }
}

