/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hudi.exception.HoodieException;

public class IMetaStoreClientUtil {
    public static IMetaStoreClient getMSC(HiveConf hiveConf) throws HiveException, MetaException {
        IMetaStoreClient metaStoreClient;
        try {
            metaStoreClient = ((Hive)Hive.class.getMethod("getWithoutRegisterFns", HiveConf.class).invoke(null, hiveConf)).getMSC();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                metaStoreClient = Hive.get((HiveConf)hiveConf).getMSC();
            }
            catch (RuntimeException e) {
                if (e.getMessage() != null && e.getMessage().contains("not org.apache.hudi.org.apache.hadoop")) {
                    throw new HoodieException(String.format("Hive Metastore compatibility issue detected. This usually happens due to:%n  (1) Hive version mismatch,%n  (2) Conflicting Hive libraries in classpath,%n  (3) Incompatible hudi-spark-bundle version.%n%nTo resolve:%n  - For Hive 2.x use hudi-spark-bundle with 'hive2' classifier,%n  - For Hive 3.x use hudi-spark-bundle with 'hive3' classifier,%n  - Ensure no conflicting Hive jars in Spark classpath.%n%nCheck: https://hudi.apache.org/docs/syncing_metastore.%n%nTechnical details: %s", e.getMessage()), (Throwable)e);
                }
                throw e;
            }
        }
        return metaStoreClient;
    }
}

