/*
 *  Copyright 2001-2005 Stephen Colebourne
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package io.trino.jdbc.$internal.joda.time.convert;

import io.trino.jdbc.$internal.joda.time.Chronology;
import io.trino.jdbc.$internal.joda.time.PeriodType;
import io.trino.jdbc.$internal.joda.time.ReadWritablePeriod;

/**
 * PeriodConverter defines how an object is converted to a time period.
 *
 * @author Stephen Colebourne
 * @author Brian S O'Neill
 * @since 1.0
 */
public interface PeriodConverter extends Converter {

    /**
     * Extracts duration values from an object of this converter's type, and
     * sets them into the given ReadWritableDuration.
     *
     * @param period  the period to modify
     * @param object  the object to convert, must not be null
     * @param chrono  the chronology to use, must not be null
     * @throws ClassCastException if the object is invalid
     */
    void setInto(ReadWritablePeriod period, Object object, Chronology chrono);

    /**
     * Selects a suitable period type for the given object.
     *
     * @param object  the object to examine, must not be null
     * @return the period type, never null
     * @throws ClassCastException if the object is invalid
     */
    PeriodType getPeriodType(Object object);

}
