package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParseException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.ContextualDeserializer;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableRangeSet;
import com.facebook.presto.jdbc.internal.guava.collect.Range;
import com.facebook.presto.jdbc.internal.guava.collect.RangeSet;

import java.io.IOException;
import java.util.List;

public class RangeSetDeserializer
    extends JsonDeserializer<RangeSet<Comparable<?>>>
    implements ContextualDeserializer
{
    private JavaType genericRangeListType;

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (genericRangeListType == null) {
            throw new JsonParseException(p, "RangeSetJsonSerializer was not contextualized (no deserialize target type). " +
                    "You need to specify the generic type down to the generic parameter of RangeSet.");
        } else {
            @SuppressWarnings("unchecked") final Iterable<Range<Comparable<?>>> ranges
                    = (Iterable<Range<Comparable<?>>>) ctxt
                    .findContextualValueDeserializer(genericRangeListType, null).deserialize(p, ctxt);
            ImmutableRangeSet.Builder<Comparable<?>> builder = ImmutableRangeSet.builder();
            for (Range<Comparable<?>> range : ranges) {
                builder.add(range);
            }
            return builder.build();
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        final JavaType genericType = ctxt.getContextualType().containedType(0);
        if (genericType == null) return this;
        final RangeSetDeserializer deserializer = new RangeSetDeserializer();
        deserializer.genericRangeListType = ctxt.getTypeFactory().constructCollectionType(List.class,
                ctxt.getTypeFactory().constructParametricType(Range.class, genericType));
        return deserializer;
    }
}
