/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package org.apache.hudi.avro.model;

import org.apache.avro.specific.SpecificData;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.SchemaStore;

@SuppressWarnings("all")
/** A record saved within the Metadata Table */
@org.apache.avro.specific.AvroGenerated
public class HoodieMetadataRecord extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
  private static final long serialVersionUID = -6951204852215386269L;
  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieMetadataRecord\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record saved within the Metadata Table\",\"fields\":[{\"name\":\"key\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"type\",\"type\":\"int\",\"doc\":\"Type of the metadata record\"},{\"name\":\"filesystemMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"HoodieMetadataFileInfo\",\"fields\":[{\"name\":\"size\",\"type\":\"long\",\"doc\":\"Size of the file\"},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"True if this file has been deleted\"}]},\"avro.java.string\":\"String\"}],\"doc\":\"Contains information about partitions and files within the dataset\"},{\"name\":\"BloomFilterMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieMetadataBloomFilter\",\"doc\":\"Data file bloom filter details\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Bloom filter type code\"},{\"name\":\"timestamp\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Instant timestamp when this metadata was created/updated\"},{\"name\":\"bloomFilter\",\"type\":\"bytes\",\"doc\":\"Bloom filter binary byte array\"},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Bloom filter entry valid/deleted flag\"}]}],\"doc\":\"Metadata Index of bloom filters for all data files in the user table\",\"default\":null},{\"name\":\"ColumnStatsMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieMetadataColumnStats\",\"doc\":\"Data file column statistics\",\"fields\":[{\"name\":\"fileName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"File name for which this column statistics applies\",\"default\":null},{\"name\":\"columnName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Column name for which this column statistics applies\",\"default\":null},{\"name\":\"minValue\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"BooleanWrapper\",\"doc\":\"A record wrapping boolean type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"IntWrapper\",\"doc\":\"A record wrapping int type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"LongWrapper\",\"doc\":\"A record wrapping long type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"FloatWrapper\",\"doc\":\"A record wrapping float type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"float\"}]},{\"type\":\"record\",\"name\":\"DoubleWrapper\",\"doc\":\"A record wrapping double type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},{\"type\":\"record\",\"name\":\"BytesWrapper\",\"doc\":\"A record wrapping bytes type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"StringWrapper\",\"doc\":\"A record wrapping string type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"DateWrapper\",\"doc\":\"A record wrapping Date logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]},{\"type\":\"record\",\"name\":\"TimeMicrosWrapper\",\"doc\":\"A record wrapping Time-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}}]},{\"type\":\"record\",\"name\":\"TimestampMicrosWrapper\",\"doc\":\"A record wrapping Timestamp-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]}],\"doc\":\"Minimum value in the range. Based on user data table schema, we can convert this to appropriate type\",\"default\":null},{\"name\":\"maxValue\",\"type\":[\"null\",\"BooleanWrapper\",\"IntWrapper\",\"LongWrapper\",\"FloatWrapper\",\"DoubleWrapper\",\"BytesWrapper\",\"StringWrapper\",\"DateWrapper\",\"DecimalWrapper\",\"TimeMicrosWrapper\",\"TimestampMicrosWrapper\"],\"doc\":\"Maximum value in the range. Based on user data table schema, we can convert it to appropriate type\",\"default\":null},{\"name\":\"valueCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of values\",\"default\":null},{\"name\":\"nullCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of null values\",\"default\":null},{\"name\":\"totalSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total storage size on disk\",\"default\":null},{\"name\":\"totalUncompressedSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total uncompressed storage size on disk\",\"default\":null},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Column range entry valid/deleted flag\"}]}],\"doc\":\"Metadata Index of column statistics for all data files in the user table\",\"default\":null},{\"name\":\"recordIndexMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieRecordIndexInfo\",\"fields\":[{\"name\":\"partitionName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the partition name the record belongs to\",\"default\":null},{\"name\":\"fileIdHighBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to high 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIdLowBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to low 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.\",\"default\":null},{\"name\":\"instantTime\",\"type\":[\"null\",\"long\"],\"doc\":\"Epoch time in millisecond representing the commit time at which record was added\",\"default\":null},{\"name\":\"fileIdEncoding\",\"type\":\"int\",\"doc\":\"Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. \\nWhen the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdHighBits and fileIndex.\",\"default\":0},{\"name\":\"position\",\"type\":[\"null\",\"long\"],\"doc\":\"Represents position of record within a file group for easier access. It will be used for index lookup.\",\"default\":null}]}],\"doc\":\"Metadata Index that contains information about record keys and their location in the dataset\",\"default\":null},{\"name\":\"SecondaryIndexMetadata\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieSecondaryIndexInfo\",\"fields\":[{\"name\":\"recordKey\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the record key that this secondary key maps to\",\"default\":null},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"True if this entry has been deleted\"}]}],\"doc\":\"Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset\",\"default\":null}]}");
  public static org.apache.avro.Schema getClassSchema() { return SCHEMA$; }

  private static SpecificData MODEL$ = new SpecificData();

  private static final BinaryMessageEncoder<HoodieMetadataRecord> ENCODER =
      new BinaryMessageEncoder<HoodieMetadataRecord>(MODEL$, SCHEMA$);

  private static final BinaryMessageDecoder<HoodieMetadataRecord> DECODER =
      new BinaryMessageDecoder<HoodieMetadataRecord>(MODEL$, SCHEMA$);

  /**
   * Return the BinaryMessageDecoder instance used by this class.
   */
  public static BinaryMessageDecoder<HoodieMetadataRecord> getDecoder() {
    return DECODER;
  }

  /**
   * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
   * @param resolver a {@link SchemaStore} used to find schemas by fingerprint
   */
  public static BinaryMessageDecoder<HoodieMetadataRecord> createDecoder(SchemaStore resolver) {
    return new BinaryMessageDecoder<HoodieMetadataRecord>(MODEL$, SCHEMA$, resolver);
  }

  /** Serializes this HoodieMetadataRecord to a ByteBuffer. */
  public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
    return ENCODER.encode(this);
  }

  /** Deserializes a HoodieMetadataRecord from a ByteBuffer. */
  public static HoodieMetadataRecord fromByteBuffer(
      java.nio.ByteBuffer b) throws java.io.IOException {
    return DECODER.decode(b);
  }

  @Deprecated public java.lang.String key;
  /** Type of the metadata record */
  @Deprecated public int type;
  /** Contains information about partitions and files within the dataset */
  @Deprecated public java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> filesystemMetadata;
  /** Metadata Index of bloom filters for all data files in the user table */
  @Deprecated public org.apache.hudi.avro.model.HoodieMetadataBloomFilter BloomFilterMetadata;
  /** Metadata Index of column statistics for all data files in the user table */
  @Deprecated public org.apache.hudi.avro.model.HoodieMetadataColumnStats ColumnStatsMetadata;
  /** Metadata Index that contains information about record keys and their location in the dataset */
  @Deprecated public org.apache.hudi.avro.model.HoodieRecordIndexInfo recordIndexMetadata;
  /** Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset */
  @Deprecated public org.apache.hudi.avro.model.HoodieSecondaryIndexInfo SecondaryIndexMetadata;

  /**
   * Default constructor.  Note that this does not initialize fields
   * to their default values from the schema.  If that is desired then
   * one should use <code>newBuilder()</code>.
   */
  public HoodieMetadataRecord() {}

  /**
   * All-args constructor.
   * @param key The new value for key
   * @param type Type of the metadata record
   * @param filesystemMetadata Contains information about partitions and files within the dataset
   * @param BloomFilterMetadata Metadata Index of bloom filters for all data files in the user table
   * @param ColumnStatsMetadata Metadata Index of column statistics for all data files in the user table
   * @param recordIndexMetadata Metadata Index that contains information about record keys and their location in the dataset
   * @param SecondaryIndexMetadata Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
   */
  public HoodieMetadataRecord(java.lang.String key, java.lang.Integer type, java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> filesystemMetadata, org.apache.hudi.avro.model.HoodieMetadataBloomFilter BloomFilterMetadata, org.apache.hudi.avro.model.HoodieMetadataColumnStats ColumnStatsMetadata, org.apache.hudi.avro.model.HoodieRecordIndexInfo recordIndexMetadata, org.apache.hudi.avro.model.HoodieSecondaryIndexInfo SecondaryIndexMetadata) {
    this.key = key;
    this.type = type;
    this.filesystemMetadata = filesystemMetadata;
    this.BloomFilterMetadata = BloomFilterMetadata;
    this.ColumnStatsMetadata = ColumnStatsMetadata;
    this.recordIndexMetadata = recordIndexMetadata;
    this.SecondaryIndexMetadata = SecondaryIndexMetadata;
  }

  public org.apache.avro.Schema getSchema() { return SCHEMA$; }
  // Used by DatumWriter.  Applications should not call.
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0: return key;
    case 1: return type;
    case 2: return filesystemMetadata;
    case 3: return BloomFilterMetadata;
    case 4: return ColumnStatsMetadata;
    case 5: return recordIndexMetadata;
    case 6: return SecondaryIndexMetadata;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  // Used by DatumReader.  Applications should not call.
  @SuppressWarnings(value="unchecked")
  public void put(int field$, java.lang.Object value$) {
    switch (field$) {
    case 0: key = (java.lang.String)value$; break;
    case 1: type = (java.lang.Integer)value$; break;
    case 2: filesystemMetadata = (java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo>)value$; break;
    case 3: BloomFilterMetadata = (org.apache.hudi.avro.model.HoodieMetadataBloomFilter)value$; break;
    case 4: ColumnStatsMetadata = (org.apache.hudi.avro.model.HoodieMetadataColumnStats)value$; break;
    case 5: recordIndexMetadata = (org.apache.hudi.avro.model.HoodieRecordIndexInfo)value$; break;
    case 6: SecondaryIndexMetadata = (org.apache.hudi.avro.model.HoodieSecondaryIndexInfo)value$; break;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  /**
   * Gets the value of the 'key' field.
   * @return The value of the 'key' field.
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Sets the value of the 'key' field.
   * @param value the value to set.
   */
  public void setKey(java.lang.String value) {
    this.key = value;
  }

  /**
   * Gets the value of the 'type' field.
   * @return Type of the metadata record
   */
  public java.lang.Integer getType() {
    return type;
  }

  /**
   * Sets the value of the 'type' field.
   * Type of the metadata record
   * @param value the value to set.
   */
  public void setType(java.lang.Integer value) {
    this.type = value;
  }

  /**
   * Gets the value of the 'filesystemMetadata' field.
   * @return Contains information about partitions and files within the dataset
   */
  public java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> getFilesystemMetadata() {
    return filesystemMetadata;
  }

  /**
   * Sets the value of the 'filesystemMetadata' field.
   * Contains information about partitions and files within the dataset
   * @param value the value to set.
   */
  public void setFilesystemMetadata(java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> value) {
    this.filesystemMetadata = value;
  }

  /**
   * Gets the value of the 'BloomFilterMetadata' field.
   * @return Metadata Index of bloom filters for all data files in the user table
   */
  public org.apache.hudi.avro.model.HoodieMetadataBloomFilter getBloomFilterMetadata() {
    return BloomFilterMetadata;
  }

  /**
   * Sets the value of the 'BloomFilterMetadata' field.
   * Metadata Index of bloom filters for all data files in the user table
   * @param value the value to set.
   */
  public void setBloomFilterMetadata(org.apache.hudi.avro.model.HoodieMetadataBloomFilter value) {
    this.BloomFilterMetadata = value;
  }

  /**
   * Gets the value of the 'ColumnStatsMetadata' field.
   * @return Metadata Index of column statistics for all data files in the user table
   */
  public org.apache.hudi.avro.model.HoodieMetadataColumnStats getColumnStatsMetadata() {
    return ColumnStatsMetadata;
  }

  /**
   * Sets the value of the 'ColumnStatsMetadata' field.
   * Metadata Index of column statistics for all data files in the user table
   * @param value the value to set.
   */
  public void setColumnStatsMetadata(org.apache.hudi.avro.model.HoodieMetadataColumnStats value) {
    this.ColumnStatsMetadata = value;
  }

  /**
   * Gets the value of the 'recordIndexMetadata' field.
   * @return Metadata Index that contains information about record keys and their location in the dataset
   */
  public org.apache.hudi.avro.model.HoodieRecordIndexInfo getRecordIndexMetadata() {
    return recordIndexMetadata;
  }

  /**
   * Sets the value of the 'recordIndexMetadata' field.
   * Metadata Index that contains information about record keys and their location in the dataset
   * @param value the value to set.
   */
  public void setRecordIndexMetadata(org.apache.hudi.avro.model.HoodieRecordIndexInfo value) {
    this.recordIndexMetadata = value;
  }

  /**
   * Gets the value of the 'SecondaryIndexMetadata' field.
   * @return Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
   */
  public org.apache.hudi.avro.model.HoodieSecondaryIndexInfo getSecondaryIndexMetadata() {
    return SecondaryIndexMetadata;
  }

  /**
   * Sets the value of the 'SecondaryIndexMetadata' field.
   * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
   * @param value the value to set.
   */
  public void setSecondaryIndexMetadata(org.apache.hudi.avro.model.HoodieSecondaryIndexInfo value) {
    this.SecondaryIndexMetadata = value;
  }

  /**
   * Creates a new HoodieMetadataRecord RecordBuilder.
   * @return A new HoodieMetadataRecord RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataRecord.Builder newBuilder() {
    return new org.apache.hudi.avro.model.HoodieMetadataRecord.Builder();
  }

  /**
   * Creates a new HoodieMetadataRecord RecordBuilder by copying an existing Builder.
   * @param other The existing builder to copy.
   * @return A new HoodieMetadataRecord RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataRecord.Builder newBuilder(org.apache.hudi.avro.model.HoodieMetadataRecord.Builder other) {
    return new org.apache.hudi.avro.model.HoodieMetadataRecord.Builder(other);
  }

  /**
   * Creates a new HoodieMetadataRecord RecordBuilder by copying an existing HoodieMetadataRecord instance.
   * @param other The existing instance to copy.
   * @return A new HoodieMetadataRecord RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataRecord.Builder newBuilder(org.apache.hudi.avro.model.HoodieMetadataRecord other) {
    return new org.apache.hudi.avro.model.HoodieMetadataRecord.Builder(other);
  }

  /**
   * RecordBuilder for HoodieMetadataRecord instances.
   */
  public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<HoodieMetadataRecord>
    implements org.apache.avro.data.RecordBuilder<HoodieMetadataRecord> {

    private java.lang.String key;
    /** Type of the metadata record */
    private int type;
    /** Contains information about partitions and files within the dataset */
    private java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> filesystemMetadata;
    /** Metadata Index of bloom filters for all data files in the user table */
    private org.apache.hudi.avro.model.HoodieMetadataBloomFilter BloomFilterMetadata;
    private org.apache.hudi.avro.model.HoodieMetadataBloomFilter.Builder BloomFilterMetadataBuilder;
    /** Metadata Index of column statistics for all data files in the user table */
    private org.apache.hudi.avro.model.HoodieMetadataColumnStats ColumnStatsMetadata;
    private org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder ColumnStatsMetadataBuilder;
    /** Metadata Index that contains information about record keys and their location in the dataset */
    private org.apache.hudi.avro.model.HoodieRecordIndexInfo recordIndexMetadata;
    private org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder recordIndexMetadataBuilder;
    /** Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset */
    private org.apache.hudi.avro.model.HoodieSecondaryIndexInfo SecondaryIndexMetadata;
    private org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.Builder SecondaryIndexMetadataBuilder;

    /** Creates a new Builder */
    private Builder() {
      super(SCHEMA$);
    }

    /**
     * Creates a Builder by copying an existing Builder.
     * @param other The existing Builder to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieMetadataRecord.Builder other) {
      super(other);
      if (isValidValue(fields()[0], other.key)) {
        this.key = data().deepCopy(fields()[0].schema(), other.key);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.type)) {
        this.type = data().deepCopy(fields()[1].schema(), other.type);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.filesystemMetadata)) {
        this.filesystemMetadata = data().deepCopy(fields()[2].schema(), other.filesystemMetadata);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.BloomFilterMetadata)) {
        this.BloomFilterMetadata = data().deepCopy(fields()[3].schema(), other.BloomFilterMetadata);
        fieldSetFlags()[3] = true;
      }
      if (other.hasBloomFilterMetadataBuilder()) {
        this.BloomFilterMetadataBuilder = org.apache.hudi.avro.model.HoodieMetadataBloomFilter.newBuilder(other.getBloomFilterMetadataBuilder());
      }
      if (isValidValue(fields()[4], other.ColumnStatsMetadata)) {
        this.ColumnStatsMetadata = data().deepCopy(fields()[4].schema(), other.ColumnStatsMetadata);
        fieldSetFlags()[4] = true;
      }
      if (other.hasColumnStatsMetadataBuilder()) {
        this.ColumnStatsMetadataBuilder = org.apache.hudi.avro.model.HoodieMetadataColumnStats.newBuilder(other.getColumnStatsMetadataBuilder());
      }
      if (isValidValue(fields()[5], other.recordIndexMetadata)) {
        this.recordIndexMetadata = data().deepCopy(fields()[5].schema(), other.recordIndexMetadata);
        fieldSetFlags()[5] = true;
      }
      if (other.hasRecordIndexMetadataBuilder()) {
        this.recordIndexMetadataBuilder = org.apache.hudi.avro.model.HoodieRecordIndexInfo.newBuilder(other.getRecordIndexMetadataBuilder());
      }
      if (isValidValue(fields()[6], other.SecondaryIndexMetadata)) {
        this.SecondaryIndexMetadata = data().deepCopy(fields()[6].schema(), other.SecondaryIndexMetadata);
        fieldSetFlags()[6] = true;
      }
      if (other.hasSecondaryIndexMetadataBuilder()) {
        this.SecondaryIndexMetadataBuilder = org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.newBuilder(other.getSecondaryIndexMetadataBuilder());
      }
    }

    /**
     * Creates a Builder by copying an existing HoodieMetadataRecord instance
     * @param other The existing instance to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieMetadataRecord other) {
            super(SCHEMA$);
      if (isValidValue(fields()[0], other.key)) {
        this.key = data().deepCopy(fields()[0].schema(), other.key);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.type)) {
        this.type = data().deepCopy(fields()[1].schema(), other.type);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.filesystemMetadata)) {
        this.filesystemMetadata = data().deepCopy(fields()[2].schema(), other.filesystemMetadata);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.BloomFilterMetadata)) {
        this.BloomFilterMetadata = data().deepCopy(fields()[3].schema(), other.BloomFilterMetadata);
        fieldSetFlags()[3] = true;
      }
      this.BloomFilterMetadataBuilder = null;
      if (isValidValue(fields()[4], other.ColumnStatsMetadata)) {
        this.ColumnStatsMetadata = data().deepCopy(fields()[4].schema(), other.ColumnStatsMetadata);
        fieldSetFlags()[4] = true;
      }
      this.ColumnStatsMetadataBuilder = null;
      if (isValidValue(fields()[5], other.recordIndexMetadata)) {
        this.recordIndexMetadata = data().deepCopy(fields()[5].schema(), other.recordIndexMetadata);
        fieldSetFlags()[5] = true;
      }
      this.recordIndexMetadataBuilder = null;
      if (isValidValue(fields()[6], other.SecondaryIndexMetadata)) {
        this.SecondaryIndexMetadata = data().deepCopy(fields()[6].schema(), other.SecondaryIndexMetadata);
        fieldSetFlags()[6] = true;
      }
      this.SecondaryIndexMetadataBuilder = null;
    }

    /**
      * Gets the value of the 'key' field.
      * @return The value.
      */
    public java.lang.String getKey() {
      return key;
    }

    /**
      * Sets the value of the 'key' field.
      * @param value The value of 'key'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setKey(java.lang.String value) {
      validate(fields()[0], value);
      this.key = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /**
      * Checks whether the 'key' field has been set.
      * @return True if the 'key' field has been set, false otherwise.
      */
    public boolean hasKey() {
      return fieldSetFlags()[0];
    }


    /**
      * Clears the value of the 'key' field.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearKey() {
      key = null;
      fieldSetFlags()[0] = false;
      return this;
    }

    /**
      * Gets the value of the 'type' field.
      * Type of the metadata record
      * @return The value.
      */
    public java.lang.Integer getType() {
      return type;
    }

    /**
      * Sets the value of the 'type' field.
      * Type of the metadata record
      * @param value The value of 'type'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setType(int value) {
      validate(fields()[1], value);
      this.type = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /**
      * Checks whether the 'type' field has been set.
      * Type of the metadata record
      * @return True if the 'type' field has been set, false otherwise.
      */
    public boolean hasType() {
      return fieldSetFlags()[1];
    }


    /**
      * Clears the value of the 'type' field.
      * Type of the metadata record
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearType() {
      fieldSetFlags()[1] = false;
      return this;
    }

    /**
      * Gets the value of the 'filesystemMetadata' field.
      * Contains information about partitions and files within the dataset
      * @return The value.
      */
    public java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> getFilesystemMetadata() {
      return filesystemMetadata;
    }

    /**
      * Sets the value of the 'filesystemMetadata' field.
      * Contains information about partitions and files within the dataset
      * @param value The value of 'filesystemMetadata'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setFilesystemMetadata(java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo> value) {
      validate(fields()[2], value);
      this.filesystemMetadata = value;
      fieldSetFlags()[2] = true;
      return this;
    }

    /**
      * Checks whether the 'filesystemMetadata' field has been set.
      * Contains information about partitions and files within the dataset
      * @return True if the 'filesystemMetadata' field has been set, false otherwise.
      */
    public boolean hasFilesystemMetadata() {
      return fieldSetFlags()[2];
    }


    /**
      * Clears the value of the 'filesystemMetadata' field.
      * Contains information about partitions and files within the dataset
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearFilesystemMetadata() {
      filesystemMetadata = null;
      fieldSetFlags()[2] = false;
      return this;
    }

    /**
      * Gets the value of the 'BloomFilterMetadata' field.
      * Metadata Index of bloom filters for all data files in the user table
      * @return The value.
      */
    public org.apache.hudi.avro.model.HoodieMetadataBloomFilter getBloomFilterMetadata() {
      return BloomFilterMetadata;
    }

    /**
      * Sets the value of the 'BloomFilterMetadata' field.
      * Metadata Index of bloom filters for all data files in the user table
      * @param value The value of 'BloomFilterMetadata'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setBloomFilterMetadata(org.apache.hudi.avro.model.HoodieMetadataBloomFilter value) {
      validate(fields()[3], value);
      this.BloomFilterMetadataBuilder = null;
      this.BloomFilterMetadata = value;
      fieldSetFlags()[3] = true;
      return this;
    }

    /**
      * Checks whether the 'BloomFilterMetadata' field has been set.
      * Metadata Index of bloom filters for all data files in the user table
      * @return True if the 'BloomFilterMetadata' field has been set, false otherwise.
      */
    public boolean hasBloomFilterMetadata() {
      return fieldSetFlags()[3];
    }

    /**
     * Gets the Builder instance for the 'BloomFilterMetadata' field and creates one if it doesn't exist yet.
     * Metadata Index of bloom filters for all data files in the user table
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataBloomFilter.Builder getBloomFilterMetadataBuilder() {
      if (BloomFilterMetadataBuilder == null) {
        if (hasBloomFilterMetadata()) {
          setBloomFilterMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataBloomFilter.newBuilder(BloomFilterMetadata));
        } else {
          setBloomFilterMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataBloomFilter.newBuilder());
        }
      }
      return BloomFilterMetadataBuilder;
    }

    /**
     * Sets the Builder instance for the 'BloomFilterMetadata' field
     * Metadata Index of bloom filters for all data files in the user table
     * @param value The builder instance that must be set.
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setBloomFilterMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataBloomFilter.Builder value) {
      clearBloomFilterMetadata();
      BloomFilterMetadataBuilder = value;
      return this;
    }

    /**
     * Checks whether the 'BloomFilterMetadata' field has an active Builder instance
     * Metadata Index of bloom filters for all data files in the user table
     * @return True if the 'BloomFilterMetadata' field has an active Builder instance
     */
    public boolean hasBloomFilterMetadataBuilder() {
      return BloomFilterMetadataBuilder != null;
    }

    /**
      * Clears the value of the 'BloomFilterMetadata' field.
      * Metadata Index of bloom filters for all data files in the user table
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearBloomFilterMetadata() {
      BloomFilterMetadata = null;
      BloomFilterMetadataBuilder = null;
      fieldSetFlags()[3] = false;
      return this;
    }

    /**
      * Gets the value of the 'ColumnStatsMetadata' field.
      * Metadata Index of column statistics for all data files in the user table
      * @return The value.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats getColumnStatsMetadata() {
      return ColumnStatsMetadata;
    }

    /**
      * Sets the value of the 'ColumnStatsMetadata' field.
      * Metadata Index of column statistics for all data files in the user table
      * @param value The value of 'ColumnStatsMetadata'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setColumnStatsMetadata(org.apache.hudi.avro.model.HoodieMetadataColumnStats value) {
      validate(fields()[4], value);
      this.ColumnStatsMetadataBuilder = null;
      this.ColumnStatsMetadata = value;
      fieldSetFlags()[4] = true;
      return this;
    }

    /**
      * Checks whether the 'ColumnStatsMetadata' field has been set.
      * Metadata Index of column statistics for all data files in the user table
      * @return True if the 'ColumnStatsMetadata' field has been set, false otherwise.
      */
    public boolean hasColumnStatsMetadata() {
      return fieldSetFlags()[4];
    }

    /**
     * Gets the Builder instance for the 'ColumnStatsMetadata' field and creates one if it doesn't exist yet.
     * Metadata Index of column statistics for all data files in the user table
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder getColumnStatsMetadataBuilder() {
      if (ColumnStatsMetadataBuilder == null) {
        if (hasColumnStatsMetadata()) {
          setColumnStatsMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataColumnStats.newBuilder(ColumnStatsMetadata));
        } else {
          setColumnStatsMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataColumnStats.newBuilder());
        }
      }
      return ColumnStatsMetadataBuilder;
    }

    /**
     * Sets the Builder instance for the 'ColumnStatsMetadata' field
     * Metadata Index of column statistics for all data files in the user table
     * @param value The builder instance that must be set.
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setColumnStatsMetadataBuilder(org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder value) {
      clearColumnStatsMetadata();
      ColumnStatsMetadataBuilder = value;
      return this;
    }

    /**
     * Checks whether the 'ColumnStatsMetadata' field has an active Builder instance
     * Metadata Index of column statistics for all data files in the user table
     * @return True if the 'ColumnStatsMetadata' field has an active Builder instance
     */
    public boolean hasColumnStatsMetadataBuilder() {
      return ColumnStatsMetadataBuilder != null;
    }

    /**
      * Clears the value of the 'ColumnStatsMetadata' field.
      * Metadata Index of column statistics for all data files in the user table
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearColumnStatsMetadata() {
      ColumnStatsMetadata = null;
      ColumnStatsMetadataBuilder = null;
      fieldSetFlags()[4] = false;
      return this;
    }

    /**
      * Gets the value of the 'recordIndexMetadata' field.
      * Metadata Index that contains information about record keys and their location in the dataset
      * @return The value.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo getRecordIndexMetadata() {
      return recordIndexMetadata;
    }

    /**
      * Sets the value of the 'recordIndexMetadata' field.
      * Metadata Index that contains information about record keys and their location in the dataset
      * @param value The value of 'recordIndexMetadata'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setRecordIndexMetadata(org.apache.hudi.avro.model.HoodieRecordIndexInfo value) {
      validate(fields()[5], value);
      this.recordIndexMetadataBuilder = null;
      this.recordIndexMetadata = value;
      fieldSetFlags()[5] = true;
      return this;
    }

    /**
      * Checks whether the 'recordIndexMetadata' field has been set.
      * Metadata Index that contains information about record keys and their location in the dataset
      * @return True if the 'recordIndexMetadata' field has been set, false otherwise.
      */
    public boolean hasRecordIndexMetadata() {
      return fieldSetFlags()[5];
    }

    /**
     * Gets the Builder instance for the 'recordIndexMetadata' field and creates one if it doesn't exist yet.
     * Metadata Index that contains information about record keys and their location in the dataset
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder getRecordIndexMetadataBuilder() {
      if (recordIndexMetadataBuilder == null) {
        if (hasRecordIndexMetadata()) {
          setRecordIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieRecordIndexInfo.newBuilder(recordIndexMetadata));
        } else {
          setRecordIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieRecordIndexInfo.newBuilder());
        }
      }
      return recordIndexMetadataBuilder;
    }

    /**
     * Sets the Builder instance for the 'recordIndexMetadata' field
     * Metadata Index that contains information about record keys and their location in the dataset
     * @param value The builder instance that must be set.
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setRecordIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder value) {
      clearRecordIndexMetadata();
      recordIndexMetadataBuilder = value;
      return this;
    }

    /**
     * Checks whether the 'recordIndexMetadata' field has an active Builder instance
     * Metadata Index that contains information about record keys and their location in the dataset
     * @return True if the 'recordIndexMetadata' field has an active Builder instance
     */
    public boolean hasRecordIndexMetadataBuilder() {
      return recordIndexMetadataBuilder != null;
    }

    /**
      * Clears the value of the 'recordIndexMetadata' field.
      * Metadata Index that contains information about record keys and their location in the dataset
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearRecordIndexMetadata() {
      recordIndexMetadata = null;
      recordIndexMetadataBuilder = null;
      fieldSetFlags()[5] = false;
      return this;
    }

    /**
      * Gets the value of the 'SecondaryIndexMetadata' field.
      * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
      * @return The value.
      */
    public org.apache.hudi.avro.model.HoodieSecondaryIndexInfo getSecondaryIndexMetadata() {
      return SecondaryIndexMetadata;
    }

    /**
      * Sets the value of the 'SecondaryIndexMetadata' field.
      * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
      * @param value The value of 'SecondaryIndexMetadata'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setSecondaryIndexMetadata(org.apache.hudi.avro.model.HoodieSecondaryIndexInfo value) {
      validate(fields()[6], value);
      this.SecondaryIndexMetadataBuilder = null;
      this.SecondaryIndexMetadata = value;
      fieldSetFlags()[6] = true;
      return this;
    }

    /**
      * Checks whether the 'SecondaryIndexMetadata' field has been set.
      * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
      * @return True if the 'SecondaryIndexMetadata' field has been set, false otherwise.
      */
    public boolean hasSecondaryIndexMetadata() {
      return fieldSetFlags()[6];
    }

    /**
     * Gets the Builder instance for the 'SecondaryIndexMetadata' field and creates one if it doesn't exist yet.
     * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.Builder getSecondaryIndexMetadataBuilder() {
      if (SecondaryIndexMetadataBuilder == null) {
        if (hasSecondaryIndexMetadata()) {
          setSecondaryIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.newBuilder(SecondaryIndexMetadata));
        } else {
          setSecondaryIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.newBuilder());
        }
      }
      return SecondaryIndexMetadataBuilder;
    }

    /**
     * Sets the Builder instance for the 'SecondaryIndexMetadata' field
     * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
     * @param value The builder instance that must be set.
     * @return This builder.
     */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder setSecondaryIndexMetadataBuilder(org.apache.hudi.avro.model.HoodieSecondaryIndexInfo.Builder value) {
      clearSecondaryIndexMetadata();
      SecondaryIndexMetadataBuilder = value;
      return this;
    }

    /**
     * Checks whether the 'SecondaryIndexMetadata' field has an active Builder instance
     * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
     * @return True if the 'SecondaryIndexMetadata' field has an active Builder instance
     */
    public boolean hasSecondaryIndexMetadataBuilder() {
      return SecondaryIndexMetadataBuilder != null;
    }

    /**
      * Clears the value of the 'SecondaryIndexMetadata' field.
      * Metadata Index that contains information about secondary keys and the corresponding record keys in the dataset
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataRecord.Builder clearSecondaryIndexMetadata() {
      SecondaryIndexMetadata = null;
      SecondaryIndexMetadataBuilder = null;
      fieldSetFlags()[6] = false;
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public HoodieMetadataRecord build() {
      try {
        HoodieMetadataRecord record = new HoodieMetadataRecord();
        record.key = fieldSetFlags()[0] ? this.key : (java.lang.String) defaultValue(fields()[0]);
        record.type = fieldSetFlags()[1] ? this.type : (java.lang.Integer) defaultValue(fields()[1]);
        record.filesystemMetadata = fieldSetFlags()[2] ? this.filesystemMetadata : (java.util.Map<java.lang.String,org.apache.hudi.avro.model.HoodieMetadataFileInfo>) defaultValue(fields()[2]);
        if (BloomFilterMetadataBuilder != null) {
          record.BloomFilterMetadata = this.BloomFilterMetadataBuilder.build();
        } else {
          record.BloomFilterMetadata = fieldSetFlags()[3] ? this.BloomFilterMetadata : (org.apache.hudi.avro.model.HoodieMetadataBloomFilter) defaultValue(fields()[3]);
        }
        if (ColumnStatsMetadataBuilder != null) {
          record.ColumnStatsMetadata = this.ColumnStatsMetadataBuilder.build();
        } else {
          record.ColumnStatsMetadata = fieldSetFlags()[4] ? this.ColumnStatsMetadata : (org.apache.hudi.avro.model.HoodieMetadataColumnStats) defaultValue(fields()[4]);
        }
        if (recordIndexMetadataBuilder != null) {
          record.recordIndexMetadata = this.recordIndexMetadataBuilder.build();
        } else {
          record.recordIndexMetadata = fieldSetFlags()[5] ? this.recordIndexMetadata : (org.apache.hudi.avro.model.HoodieRecordIndexInfo) defaultValue(fields()[5]);
        }
        if (SecondaryIndexMetadataBuilder != null) {
          record.SecondaryIndexMetadata = this.SecondaryIndexMetadataBuilder.build();
        } else {
          record.SecondaryIndexMetadata = fieldSetFlags()[6] ? this.SecondaryIndexMetadata : (org.apache.hudi.avro.model.HoodieSecondaryIndexInfo) defaultValue(fields()[6]);
        }
        return record;
      } catch (java.lang.Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumWriter<HoodieMetadataRecord>
    WRITER$ = (org.apache.avro.io.DatumWriter<HoodieMetadataRecord>)MODEL$.createDatumWriter(SCHEMA$);

  @Override public void writeExternal(java.io.ObjectOutput out)
    throws java.io.IOException {
    WRITER$.write(this, SpecificData.getEncoder(out));
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumReader<HoodieMetadataRecord>
    READER$ = (org.apache.avro.io.DatumReader<HoodieMetadataRecord>)MODEL$.createDatumReader(SCHEMA$);

  @Override public void readExternal(java.io.ObjectInput in)
    throws java.io.IOException {
    READER$.read(this, SpecificData.getDecoder(in));
  }

}
