/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.helpers.HiveServiceProvider;

public class HiveQueryNode
extends DagNode<Boolean> {
    private HiveServiceProvider hiveServiceProvider;

    public HiveQueryNode(DeltaConfig.Config config) {
        this.config = config;
        this.hiveServiceProvider = new HiveServiceProvider(config);
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        log.info("Executing hive query node {}", (Object)this.getName());
        this.hiveServiceProvider.startLocalHiveServiceIfNeeded(executionContext.getHoodieTestSuiteWriter().getConfiguration());
        HiveSyncConfig hiveSyncConfig = DataSourceUtils.buildHiveSyncConfig((TypedProperties)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getProps(), (String)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getCfg().targetBasePath, (String)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getCfg().baseFileFormat);
        this.hiveServiceProvider.syncToLocalHiveIfNeeded(executionContext.getHoodieTestSuiteWriter());
        Connection con = DriverManager.getConnection(hiveSyncConfig.jdbcUrl, hiveSyncConfig.hiveUser, hiveSyncConfig.hivePass);
        Statement stmt = con.createStatement();
        stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
        for (String string : this.config.getHiveProperties()) {
            this.executeStatement(string, stmt);
        }
        for (Pair pair : this.config.getHiveQueries()) {
            log.info("Running {}", pair.getLeft());
            ResultSet res = stmt.executeQuery((String)pair.getLeft());
            if (!res.next()) {
                log.info("res.next() was False - typically this means the query returned no rows.");
                assert (0 == (Integer)pair.getRight());
            } else {
                Integer result = res.getInt(1);
                if (!((Integer)pair.getRight()).equals(result)) {
                    throw new AssertionError((Object)("QUERY: " + (String)pair.getLeft() + " | EXPECTED RESULT = " + pair.getRight() + " | ACTUAL RESULT = " + result));
                }
            }
            log.info("Successfully validated query!");
        }
        this.hiveServiceProvider.stopLocalHiveServiceIfNeeded();
    }

    private void executeStatement(String query, Statement stmt) throws SQLException {
        log.info("Executing statement {}", (Object)stmt.toString());
        stmt.execute(query);
    }
}

