/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.helpers;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hudi.hive.testutils.HiveTestService;
import org.apache.hudi.integ.testsuite.HoodieTestSuiteWriter;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;

public class HiveServiceProvider {
    private HiveTestService hiveService;
    private HiveServer2 hiveServer;
    private DeltaConfig.Config config;

    public HiveServiceProvider(DeltaConfig.Config config) {
        this.config = config;
    }

    public void startLocalHiveServiceIfNeeded(Configuration configuration) throws IOException {
        if (this.config.isHiveLocal()) {
            this.hiveService = new HiveTestService(configuration);
            this.hiveServer = this.hiveService.start();
        }
    }

    public void syncToLocalHiveIfNeeded(HoodieTestSuiteWriter writer) {
        if (this.config.isHiveLocal()) {
            writer.getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().syncHive(this.getLocalHiveServer().getHiveConf());
        } else {
            writer.getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().syncHive();
        }
    }

    public void stopLocalHiveServiceIfNeeded() throws IOException {
        if (this.config.isHiveLocal() && this.hiveService != null) {
            this.hiveService.stop();
        }
    }

    public HiveServer2 getLocalHiveServer() {
        return this.hiveServer;
    }
}

