/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.HoodieReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.integ.testsuite.HoodieDeltaStreamerWrapper;
import org.apache.hudi.integ.testsuite.HoodieTestSuiteJob;
import org.apache.hudi.integ.testsuite.dag.nodes.CleanNode;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.dag.nodes.RollbackNode;
import org.apache.hudi.integ.testsuite.dag.nodes.ScheduleCompactNode;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieTestSuiteWriter
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(HoodieTestSuiteWriter.class);
    protected HoodieDeltaStreamerWrapper deltaStreamerWrapper;
    protected HoodieWriteConfig writeConfig;
    protected SparkRDDWriteClient writeClient;
    protected HoodieTestSuiteJob.HoodieTestSuiteConfig cfg;
    protected Option<String> lastCheckpoint;
    protected HoodieReadClient hoodieReadClient;
    protected Properties props;
    protected String schema;
    protected transient Configuration configuration;
    protected transient JavaSparkContext sparkContext;
    protected static Set<String> VALID_DAG_NODES_TO_ALLOW_WRITE_CLIENT_IN_DELTASTREAMER_MODE = new HashSet<String>(Arrays.asList(RollbackNode.class.getName(), CleanNode.class.getName(), ScheduleCompactNode.class.getName()));

    public HoodieTestSuiteWriter(JavaSparkContext jsc, Properties props, HoodieTestSuiteJob.HoodieTestSuiteConfig cfg, String schema) throws Exception {
        HoodieSparkEngineContext context = new HoodieSparkEngineContext(jsc);
        this.deltaStreamerWrapper = new HoodieDeltaStreamerWrapper(cfg, jsc);
        this.hoodieReadClient = new HoodieReadClient(context, cfg.targetBasePath);
        this.writeConfig = this.getHoodieClientConfig(cfg, props, schema);
        if (!cfg.useDeltaStreamer.booleanValue()) {
            this.writeClient = new SparkRDDWriteClient((HoodieEngineContext)context, this.writeConfig);
        }
        this.cfg = cfg;
        this.configuration = jsc.hadoopConfiguration();
        this.sparkContext = jsc;
        this.props = props;
        this.schema = schema;
    }

    public HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }

    private HoodieWriteConfig getHoodieClientConfig(HoodieTestSuiteJob.HoodieTestSuiteConfig cfg, Properties props, String schema) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(cfg.targetBasePath).withAutoCommit(false).withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadOrderingField(cfg.sourceOrderingField).withPayloadClass(cfg.payloadClassName).build()).forTable(cfg.targetTableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withProps((Map)props);
        builder = builder.withSchema(schema);
        return builder.build();
    }

    private boolean allowWriteClientAccess(DagNode dagNode) {
        return VALID_DAG_NODES_TO_ALLOW_WRITE_CLIENT_IN_DELTASTREAMER_MODE.contains(dagNode.getClass().getName());
    }

    public abstract void shutdownResources();

    public abstract RDD<GenericRecord> getNextBatch() throws Exception;

    public abstract Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> fetchSource() throws Exception;

    public abstract Option<String> startCommit();

    public abstract JavaRDD<WriteStatus> upsert(Option<String> var1) throws Exception;

    public abstract JavaRDD<WriteStatus> insert(Option<String> var1) throws Exception;

    public abstract JavaRDD<WriteStatus> insertOverwrite(Option<String> var1) throws Exception;

    public abstract JavaRDD<WriteStatus> insertOverwriteTable(Option<String> var1) throws Exception;

    public abstract JavaRDD<WriteStatus> bulkInsert(Option<String> var1) throws Exception;

    public abstract JavaRDD<WriteStatus> compact(Option<String> var1) throws Exception;

    public abstract void inlineClustering() throws Exception;

    public abstract Option<String> scheduleCompaction(Option<Map<String, String>> var1) throws Exception;

    public abstract void commit(JavaRDD<WriteStatus> var1, JavaRDD<DeltaWriteStats> var2, Option<String> var3);

    public abstract void commitCompaction(JavaRDD<WriteStatus> var1, JavaRDD<DeltaWriteStats> var2, Option<String> var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkRDDWriteClient getWriteClient(DagNode dagNode) throws IllegalAccessException {
        if (this.cfg.useDeltaStreamer & !this.allowWriteClientAccess(dagNode)) {
            throw new IllegalAccessException("cannot access write client when testing in deltastreamer mode");
        }
        HoodieTestSuiteWriter hoodieTestSuiteWriter = this;
        synchronized (hoodieTestSuiteWriter) {
            if (this.writeClient == null) {
                this.writeClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.sparkContext), this.getHoodieClientConfig(this.cfg, this.props, this.schema));
            }
        }
        return this.writeClient;
    }

    public HoodieDeltaStreamerWrapper getDeltaStreamerWrapper() {
        return this.deltaStreamerWrapper;
    }

    public HoodieTestSuiteJob.HoodieTestSuiteConfig getCfg() {
        return this.cfg;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JavaSparkContext getSparkContext() {
        return this.sparkContext;
    }

    public Option<String> getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getSchema() {
        return this.schema;
    }
}

