/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;

public class DeleteInputDatasetNode
extends DagNode<Boolean> {
    public DeleteInputDatasetNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext context, int curItrCount) throws Exception {
        String latestBatch = String.valueOf(context.getWriterContext().getDeltaGenerator().getBatchId());
        if (this.config.isDeleteInputDataExceptLatest()) {
            FileStatus[] fileStatuses;
            String inputPathStr = context.getHoodieTestSuiteWriter().getCfg().inputBasePath;
            FileSystem fs = new Path(inputPathStr).getFileSystem(context.getHoodieTestSuiteWriter().getConfiguration());
            for (FileStatus fileStatus : fileStatuses = fs.listStatus(new Path(inputPathStr))) {
                if (fileStatus.getPath().getName().equals(latestBatch)) continue;
                log.debug("Micro batch to be deleted " + fileStatus.getPath().toString());
                fs.delete(fileStatus.getPath(), true);
            }
        }
    }
}

