/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.BaseQueryNode;
import org.apache.hudi.integ.testsuite.helpers.HiveServiceProvider;
import org.apache.hudi.sync.common.HoodieSyncConfig;

public class HiveQueryNode
extends BaseQueryNode {
    private HiveServiceProvider hiveServiceProvider;

    public HiveQueryNode(DeltaConfig.Config config) {
        this.config = config;
        this.hiveServiceProvider = new HiveServiceProvider(config);
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        log.info("Executing hive query node {}", (Object)this.getName());
        this.hiveServiceProvider.startLocalHiveServiceIfNeeded(executionContext.getHoodieTestSuiteWriter().getConfiguration());
        TypedProperties properties = new TypedProperties();
        properties.putAll((Map)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getProps());
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getCfg().targetBasePath);
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), (Object)executionContext.getHoodieTestSuiteWriter().getDeltaStreamerWrapper().getDeltaSyncService().getDeltaSync().getCfg().baseFileFormat);
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig((Properties)properties);
        this.hiveServiceProvider.syncToLocalHiveIfNeeded(executionContext.getHoodieTestSuiteWriter());
        try (Connection con = DriverManager.getConnection(hiveSyncConfig.getString(HiveSyncConfigHolder.HIVE_URL), hiveSyncConfig.getString(HiveSyncConfigHolder.HIVE_USER), hiveSyncConfig.getString(HiveSyncConfigHolder.HIVE_PASS));){
            Statement stmt = con.createStatement();
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            this.setSessionProperties(this.config.getHiveProperties(), stmt);
            this.executeAndValidateQueries(this.config.getHiveQueries(), stmt);
            stmt.close();
            this.hiveServiceProvider.stopLocalHiveServiceIfNeeded();
        }
        catch (Exception e) {
            throw new HoodieValidationException("Hive query validation failed due to " + e.getMessage(), (Throwable)e);
        }
    }
}

