/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAsyncOperations
extends DagNode<Option<String>> {
    private static Logger log = LoggerFactory.getLogger(ValidateAsyncOperations.class);

    public ValidateAsyncOperations(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        if (this.config.getIterationCountToExecute() == curItrCount) {
            try {
                log.warn("Executing ValidateHoodieAsyncOperations node {} with target base path {} ", (Object)this.getName(), (Object)executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
                String basePath = executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath;
                int maxCommitsRetained = executionContext.getHoodieTestSuiteWriter().getWriteConfig().getCleanerCommitsRetained() + 1;
                FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)executionContext.getHoodieTestSuiteWriter().getConfiguration());
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath).setConf(executionContext.getJsc().hadoopConfiguration()).build();
                Option latestCleanInstant = metaClient.getActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant();
                if (latestCleanInstant.isPresent()) {
                    log.warn("Latest clean commit " + latestCleanInstant.get());
                    HoodieCleanMetadata cleanMetadata = CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)metaClient, (HoodieInstant)((HoodieInstant)latestCleanInstant.get()));
                    String earliestCommitToRetain = cleanMetadata.getEarliestCommitToRetain();
                    log.warn("Earliest commit to retain : " + earliestCommitToRetain);
                    long unCleanedInstants = metaClient.getActiveTimeline().filterCompletedInstants().filter(instant -> HoodieTimeline.compareTimestamps((String)instant.getTimestamp(), (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)earliestCommitToRetain)).getInstants().count();
                    ValidationUtils.checkArgument((unCleanedInstants >= (long)(maxCommitsRetained + 1) ? 1 : 0) != 0, (String)("Total uncleaned instants " + unCleanedInstants + " mismatched with max commits retained " + (maxCommitsRetained + 1)));
                }
                if (this.config.validateArchival() || this.config.validateClean()) {
                    Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("\\.commits_\\.archive\\..*");
                    Pattern CLEAN_FILE_PATTERN = Pattern.compile(".*\\.clean\\..*");
                    String metadataPath = executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath + "/.hoodie";
                    FileStatus[] metaFileStatuses = fs.listStatus(new Path(metadataPath));
                    boolean cleanFound = false;
                    for (FileStatus fileStatus : metaFileStatuses) {
                        Matcher cleanFileMatcher = CLEAN_FILE_PATTERN.matcher(fileStatus.getPath().getName());
                        if (!cleanFileMatcher.matches()) continue;
                        cleanFound = true;
                        break;
                    }
                    String archivalPath = executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath + "/.hoodie/archived";
                    metaFileStatuses = fs.listStatus(new Path(archivalPath));
                    boolean archFound = false;
                    for (FileStatus fileStatus : metaFileStatuses) {
                        Matcher archFileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileStatus.getPath().getName());
                        if (!archFileMatcher.matches()) continue;
                        archFound = true;
                    }
                    if (this.config.validateArchival() && !archFound) {
                        throw new AssertionError((Object)("Archival NotFound in " + metadataPath));
                    }
                    if (this.config.validateClean() && !cleanFound) {
                        throw new AssertionError((Object)("Clean commits NotFound in " + metadataPath));
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception thrown in ValidateHoodieAsyncOperations Node :: " + e.getCause() + ", msg :: " + e.getMessage());
                throw e;
            }
        }
    }
}

