/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes.spark.sql;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.utils.SparkSqlUtils$;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u0006\r\u0003\u0003y\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000b)\u0003A\u0011A&\t\u000f=\u0003!\u0019!C\u0001!\"1q\u000b\u0001Q\u0001\nECq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\u0006G\u00021\t\u0001\u001a\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\u0011\u0001CQ1tKN\u0003\u0018M]6Tc2tu\u000eZ3\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\tQA\\8eKNT!a\u0005\u000b\u0002\u0007\u0011\fwM\u0003\u0002\u0016-\u0005IA/Z:ugVLG/\u001a\u0006\u0003/a\tQ!\u001b8uK\u001eT!!\u0007\u000e\u0002\t!,H-\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003cA\u0011#I5\t\u0001#\u0003\u0002$!\t9A)Y4O_\u0012,\u0007cA\u0013*W5\taE\u0003\u0002(Q\u0005\u0019!\u000f\u001a3\u000b\u0005=Q\u0012B\u0001\u0016'\u0005\r\u0011F\t\u0012\t\u0003Y=j\u0011!\f\u0006\u0003]a\taa\u00197jK:$\u0018B\u0001\u0019.\u0005-9&/\u001b;f'R\fG/^:\u0002\u001b\u0011\fwMT8eK\u000e{gNZ5h!\t\u0019tI\u0004\u00025\t:\u0011QG\u0011\b\u0003m\u0005s!a\u000e!\u000f\u0005azdBA\u001d?\u001d\tQT(D\u0001<\u0015\tad$\u0001\u0004=e>|GOP\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA\"\u0015\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011QIR\u0001\f\t\u0016dG/Y\"p]\u001aLwM\u0003\u0002D)%\u0011\u0001*\u0013\u0002\u0007\u0007>tg-[4\u000b\u0005\u00153\u0015A\u0002\u001fj]&$h\b\u0006\u0002M\u001dB\u0011Q\nA\u0007\u0002\u0019!)\u0011G\u0001a\u0001e\u0005\u0019AjT$\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001\u0016\u000f\u0002\u000bMdg\r\u000e6\n\u0005Y\u001b&A\u0002'pO\u001e,'/\u0001\u0003M\u001f\u001e\u0003\u0013a\u0004+F\u001bB{F+\u0011\"M\u000b~s\u0015)T#\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0004TiJLgnZ\u0001\u0011)\u0016k\u0005k\u0018+B\u00052+uLT!N\u000b\u0002\n!\"];fef$vNU;o)\r)g\u000e\u001d\t\u0003M2t!a\u001a6\u0011\u0005iB'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D\u0017A\u0002)sK\u0012,g-\u0003\u0002b[*\u00111\u000e\u001b\u0005\u0006_\u001e\u0001\rAM\u0001\u0007G>tg-[4\t\u000bE<\u0001\u0019\u0001:\u0002\u000f\r|g\u000e^3yiB\u00111\u000f^\u0007\u0002%%\u0011QO\u0005\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1\u0002\u001d:fa\u0006\u0014X\rR1uCR\u0019\u00010a\u0001\u0011\u0007\u0015J\u0013\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u00069q-\u001a8fe&\u001c'B\u0001@\u001b\u0003\u0011\tgO]8\n\u0007\u0005\u00051PA\u0007HK:,'/[2SK\u000e|'\u000f\u001a\u0005\u0006c\"\u0001\rA]\u0001\u0011O\u0016$H+Z7q)\u0006\u0014G.\u001a(b[\u0016$\u0012!Z\u0001\bKb,7-\u001e;f)\u0019\ti!!\u0006\u0002\u0018A!\u0011qBA\t\u001b\u0005A\u0017bAA\nQ\n!QK\\5u\u0011\u0015\t(\u00021\u0001s\u0011\u001d\tIB\u0003a\u0001\u00037\t1bY;s\u0013R\u00148i\\;oiB!\u0011qBA\u000f\u0013\r\ty\u0002\u001b\u0002\u0004\u0013:$\b")
public abstract class BaseSparkSqlNode
extends DagNode<RDD<WriteStatus>> {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String TEMP_TABLE_NAME;

    public Logger LOG() {
        return this.LOG;
    }

    public String TEMP_TABLE_NAME() {
        return this.TEMP_TABLE_NAME;
    }

    public abstract String queryToRun(DeltaConfig.Config var1, ExecutionContext var2);

    public RDD<GenericRecord> prepareData(ExecutionContext context) {
        Object object = !this.config.isDisableGenerate() ? BoxesRunTime.boxToLong((long)((JavaRDDLike)context.getDeltaGenerator().writeRecords(context.getDeltaGenerator().generateInserts(this.config)).getValue()).count()) : BoxedUnit.UNIT;
        return context.getWriterContext().getHoodieTestSuiteWriter().getNextBatch();
    }

    public String getTempTableName() {
        return this.TEMP_TABLE_NAME();
    }

    @Override
    public void execute(ExecutionContext context, int curItrCount) {
        this.LOG().info("Run query in Spark SQL ...");
        RDD<GenericRecord> nextBatch = this.prepareData(context);
        SparkSession sparkSession = context.getWriterContext().getSparkSession();
        Dataset inputDF = AvroConversionUtils$.MODULE$.createDataFrame(nextBatch, context.getWriterContext().getHoodieTestSuiteWriter().getSchema(), sparkSession);
        inputDF.createOrReplaceTempView(this.TEMP_TABLE_NAME());
        String query = this.queryToRun(this.config, context);
        SparkSqlUtils$.MODULE$.logQuery(this.LOG(), query);
        sparkSession.sql(query);
        this.LOG().info("Finish run query in Spark SQL.");
    }

    public BaseSparkSqlNode(DeltaConfig.Config dagNodeConfig) {
        this.TEMP_TABLE_NAME = "_spark_sql_temp_table";
        this.config = dagNodeConfig;
    }
}

