/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes.spark.sql;

import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.utils.SparkSqlUtils$;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A\u0001C\u0005\u00019!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u0003H\u0001\u0011\u0005\u0001\nC\u0004M\u0001\t\u0007I\u0011A'\t\rQ\u0003\u0001\u0015!\u0003O\u0011\u001d)\u0006A1A\u0005\u0002YCa!\u0019\u0001!\u0002\u00139\u0006\"\u00022\u0001\t\u0003\u001a'aF*qCJ\\7+\u001d7De\u0016\fG/\u001a+bE2,gj\u001c3f\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011!\u00028pI\u0016\u001c(B\u0001\t\u0012\u0003\r!\u0017m\u001a\u0006\u0003%M\t\u0011\u0002^3tiN,\u0018\u000e^3\u000b\u0005Q)\u0012!B5oi\u0016<'B\u0001\f\u0018\u0003\u0011AW\u000fZ5\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004E\u0002\u001f?\u0005j\u0011!D\u0005\u0003A5\u0011q\u0001R1h\u001d>$W\rE\u0002#M!j\u0011a\t\u0006\u0003I\u0015\n1A\u001d3e\u0015\taq#\u0003\u0002(G\t\u0019!\u000b\u0012#\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-*\u0012AB2mS\u0016tG/\u0003\u0002.U\tYqK]5uKN#\u0018\r^;t\u00035!\u0017m\u001a(pI\u0016\u001cuN\u001c4jOB\u0011\u0001\u0007\u0012\b\u0003c\u0005s!AM \u000f\u0005MrdB\u0001\u001b>\u001d\t)DH\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011hG\u0001\u0007yI|w\u000e\u001e \n\u0003iI!\u0001G\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002A#\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!AQ\"\u0002\u0017\u0011+G\u000e^1D_:4\u0017n\u001a\u0006\u0003\u0001FI!!\u0012$\u0003\r\r{gNZ5h\u0015\t\u00115)\u0001\u0004=S:LGO\u0010\u000b\u0003\u0013.\u0003\"A\u0013\u0001\u000e\u0003%AQA\f\u0002A\u0002=\n1\u0001T(H+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)\u001a\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0019\u0006K\u0001\u0004M_\u001e<WM]\u0001\u0005\u0019>;\u0005%A\bU\u000b6\u0003v\fV!C\u0019\u0016{f*Q'F+\u00059\u0006C\u0001-_\u001d\tIF\f\u0005\u000285*\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\u00061\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti&,\u0001\tU\u000b6\u0003v\fV!C\u0019\u0016{f*Q'FA\u00059Q\r_3dkR,Gc\u00013i]B\u0011QMZ\u0007\u00025&\u0011qM\u0017\u0002\u0005+:LG\u000fC\u0003j\u000f\u0001\u0007!.A\u0004d_:$X\r\u001f;\u0011\u0005-dW\"A\b\n\u00055|!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015yw\u00011\u0001q\u0003-\u0019WO]%ue\u000e{WO\u001c;\u0011\u0005\u0015\f\u0018B\u0001:[\u0005\rIe\u000e\u001e")
public class SparkSqlCreateTableNode
extends DagNode<RDD<WriteStatus>> {
    private final Logger LOG = LoggerFactory.getLogger(SparkSqlCreateTableNode.class);
    private final String TEMP_TABLE_NAME;

    public Logger LOG() {
        return this.LOG;
    }

    public String TEMP_TABLE_NAME() {
        return this.TEMP_TABLE_NAME;
    }

    @Override
    public void execute(ExecutionContext context, int curItrCount) {
        Object object;
        this.LOG().info("Creating table in Spark SQL ...");
        SparkSession sparkSession = context.getWriterContext().getSparkSession();
        String targetTableName = context.getWriterContext().getCfg().targetTableName;
        String targetBasePath = new StringBuilder(4).append(context.getWriterContext().getCfg().targetBasePath).append("_sql").toString();
        if (this.config.shouldUseCtas()) {
            Object object2 = !this.config.isDisableGenerate() ? BoxesRunTime.boxToLong((long)((JavaRDDLike)context.getDeltaGenerator().writeRecords(context.getDeltaGenerator().generateInserts(this.config)).getValue()).count()) : BoxedUnit.UNIT;
            RDD<GenericRecord> nextBatch = context.getWriterContext().getHoodieTestSuiteWriter().getNextBatch();
            SparkSession sparkSession2 = context.getWriterContext().getSparkSession();
            Dataset inputDF = AvroConversionUtils$.MODULE$.createDataFrame(nextBatch, context.getWriterContext().getHoodieTestSuiteWriter().getSchema(), sparkSession2);
            inputDF.createOrReplaceTempView(this.TEMP_TABLE_NAME());
        }
        sparkSession.sql(new StringBuilder(21).append("drop table if exists ").append(targetTableName).toString());
        if (this.config.isTableExternal()) {
            this.LOG().info(new StringBuilder(9).append("Clean up ").append(targetBasePath).toString());
            FileSystem fs = FSUtils.getFs((String)targetBasePath, (Configuration)context.getJsc().hadoopConfiguration());
            Path targetPath = new Path(targetBasePath);
            object = fs.exists(targetPath) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(targetPath, true)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        String createTableQuery = SparkSqlUtils$.MODULE$.constructCreateTableQuery(this.config, targetTableName, targetBasePath, context.getWriterContext().getHoodieTestSuiteWriter().getSchema(), this.TEMP_TABLE_NAME());
        SparkSqlUtils$.MODULE$.logQuery(this.LOG(), createTableQuery);
        sparkSession.sql(createTableQuery);
        Dataset targetTableCount = sparkSession.sql(new StringBuilder(14).append("select * from ").append(targetTableName).toString());
        this.LOG().info(new StringBuilder(20).append("Target table count: ").append(targetTableCount.count()).toString());
        this.LOG().info("Finish create table in Spark SQL.");
    }

    public SparkSqlCreateTableNode(DeltaConfig.Config dagNodeConfig) {
        this.TEMP_TABLE_NAME = "_spark_sql_temp_table";
        this.config = dagNodeConfig;
    }
}

