/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadGenerator;

public class FlexibleSchemaRecordGenerationIterator
implements Iterator<GenericRecord> {
    private long counter;
    private GenericRecordFullPayloadGenerator generator;
    private GenericRecord lastRecord;
    private Set<String> partitionPathFieldNames;
    private String firstPartitionPathField;

    public FlexibleSchemaRecordGenerationIterator(long maxEntriesToProduce, String schema) {
        this(maxEntriesToProduce, 10240, schema, null, 50, 0);
    }

    public FlexibleSchemaRecordGenerationIterator(long maxEntriesToProduce, int minPayloadSize, String schemaStr, List<String> partitionPathFieldNames, int numPartitions, int startPartition) {
        this.counter = maxEntriesToProduce;
        this.partitionPathFieldNames = new HashSet<String>(partitionPathFieldNames);
        if (partitionPathFieldNames != null && partitionPathFieldNames.size() > 0) {
            this.firstPartitionPathField = partitionPathFieldNames.get(0);
        }
        Schema schema = new Schema.Parser().parse(schemaStr);
        this.generator = new GenericRecordFullPayloadGenerator(schema, minPayloadSize, numPartitions, startPartition);
    }

    @Override
    public boolean hasNext() {
        return this.counter > 0L;
    }

    @Override
    public GenericRecord next() {
        boolean partitionPathsNonEmpty;
        --this.counter;
        boolean bl = partitionPathsNonEmpty = this.partitionPathFieldNames != null && this.partitionPathFieldNames.size() > 0;
        if (this.lastRecord == null) {
            GenericRecord record;
            this.lastRecord = record = partitionPathsNonEmpty ? this.generator.getNewPayloadWithTimestamp(this.firstPartitionPathField) : this.generator.getNewPayload(this.partitionPathFieldNames);
            return record;
        }
        return partitionPathsNonEmpty ? this.generator.getUpdatePayloadWithTimestamp(this.lastRecord, this.partitionPathFieldNames, this.firstPartitionPathField) : this.generator.getUpdatePayload(this.lastRecord, this.partitionPathFieldNames);
    }
}

