/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.integ.testsuite.SparkDataSourceContinuousIngest;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class SparkDataSourceContinuousIngestTool {
    private static final Logger LOG = LogManager.getLogger(SparkDataSourceContinuousIngestTool.class);
    private final Config cfg;
    private TypedProperties props;
    private HoodieSparkEngineContext context;
    private SparkSession sparkSession;

    public SparkDataSourceContinuousIngestTool(JavaSparkContext jsc, Config cfg) {
        if (cfg.propsFilePath != null) {
            cfg.propsFilePath = FSUtils.addSchemeIfLocalPath((String)cfg.propsFilePath).toString();
        }
        this.context = new HoodieSparkEngineContext(jsc);
        this.sparkSession = SparkSession.builder().config(jsc.getConf()).getOrCreate();
        this.cfg = cfg;
        this.props = cfg.propsFilePath == null ? UtilHelpers.buildProperties(cfg.configs) : this.readConfigFromFileSystem(jsc, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        JavaSparkContext jsc = UtilHelpers.buildSparkContext((String)"spark-datasource-continuous-ingestion-tool", (String)cfg.sparkMaster, (String)cfg.sparkMemory);
        try {
            new SparkDataSourceContinuousIngestTool(jsc, cfg).run();
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Fail to run Continuous Ingestion for spark datasource " + cfg.basePath), throwable);
        }
        finally {
            jsc.stop();
        }
    }

    public void run() {
        try {
            SparkDataSourceContinuousIngest sparkDataSourceContinuousIngest = new SparkDataSourceContinuousIngest(this.sparkSession, this.context.getHadoopConf().get(), new Path(this.cfg.sourcePath), this.cfg.sparkFormat, new Path(this.cfg.checkpointFilePath), new Path(this.cfg.basePath), this.getPropsAsMap(this.props), this.cfg.minSyncIntervalSeconds.intValue());
            sparkDataSourceContinuousIngest.startIngestion();
        }
        finally {
            this.sparkSession.stop();
            this.context.getJavaSparkContext().stop();
        }
    }

    private Map<String, String> getPropsAsMap(TypedProperties typedProperties) {
        HashMap<String, String> props = new HashMap<String, String>();
        typedProperties.entrySet().forEach(entry -> props.put(entry.getKey().toString(), entry.getValue().toString()));
        return props;
    }

    private TypedProperties readConfigFromFileSystem(JavaSparkContext jsc, Config cfg) {
        return UtilHelpers.readConfig((Configuration)jsc.hadoopConfiguration(), (Path)new Path(cfg.propsFilePath), cfg.configs).getProps(true);
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--source-path", "-sp"}, description="Source path for the parquet data to consume", required=true)
        public String sourcePath = null;
        @Parameter(names={"--source-format", "-sf"}, description="source data format", required=false)
        public String sparkFormat = "parquet";
        @Parameter(names={"--checkpoint-file-path", "-cpf"}, description="Checkpoint file path to store/fetch checkpointing info", required=true)
        public String checkpointFilePath = null;
        @Parameter(names={"--base-path", "-bp"}, description="Base path for the hudi table", required=true)
        public String basePath = null;
        @Parameter(names={"--spark-master", "-ms"}, description="Spark master", required=false)
        public String sparkMaster = null;
        @Parameter(names={"--spark-memory", "-sm"}, description="spark memory to use", required=false)
        public String sparkMemory = "1g";
        @Parameter(names={"--min-sync-interval-seconds"}, description="the min sync interval of each sync in continuous mode")
        public Integer minSyncIntervalSeconds = 0;
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for table repair")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
    }
}

