/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;

public abstract class BaseQueryNode
extends DagNode<Boolean> {
    public void setSessionProperties(List<String> properties, Statement stmt) throws SQLException {
        for (String prop : properties) {
            this.executeStatement(prop, stmt);
        }
    }

    public void executeAndValidateQueries(List<Pair<String, Integer>> queriesWithResult, Statement stmt) throws SQLException {
        for (Pair<String, Integer> queryAndResult : queriesWithResult) {
            log.info("Running {}", queryAndResult.getLeft());
            ResultSet res = stmt.executeQuery((String)queryAndResult.getLeft());
            if (!res.next()) {
                log.info("res.next() was False - typically this means the query returned no rows.");
                assert (0 == (Integer)queryAndResult.getRight());
            } else {
                Integer result = res.getInt(1);
                if (!((Integer)queryAndResult.getRight()).equals(result)) {
                    throw new AssertionError((Object)("QUERY: " + (String)queryAndResult.getLeft() + " | EXPECTED RESULT = " + queryAndResult.getRight() + " | ACTUAL RESULT = " + result));
                }
            }
            log.info("Successfully validated query!");
        }
    }

    private void executeStatement(String query, Statement stmt) throws SQLException {
        log.info("Executing statement {}", (Object)stmt.toString());
        stmt.execute(query);
    }
}

