/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.BaseQueryNode;

public class PrestoQueryNode
extends BaseQueryNode {
    public PrestoQueryNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext context, int curItrCount) throws Exception {
        log.info("Executing presto query node {}", (Object)this.getName());
        String url = context.getHoodieTestSuiteWriter().getCfg().prestoJdbcUrl;
        if (StringUtils.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("Presto JDBC connection url not provided. Please set --presto-jdbc-url.");
        }
        String user = context.getHoodieTestSuiteWriter().getCfg().prestoUsername;
        String pass = context.getHoodieTestSuiteWriter().getCfg().prestoPassword;
        try {
            Class.forName("com.facebook.presto.jdbc.PrestoDriver");
        }
        catch (ClassNotFoundException e) {
            throw new HoodieValidationException("Presto query validation failed due to " + e.getMessage(), (Throwable)e);
        }
        try (Connection connection = DriverManager.getConnection(url, user, pass);){
            Statement stmt = connection.createStatement();
            this.setSessionProperties(this.config.getPrestoProperties(), stmt);
            this.executeAndValidateQueries(this.config.getPrestoQueries(), stmt);
            stmt.close();
        }
        catch (Exception e) {
            throw new HoodieValidationException("Presto query validation failed due to " + e.getMessage(), (Throwable)e);
        }
    }
}

