/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.scheduler;

import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.integ.testsuite.dag.WorkflowDag;
import org.apache.hudi.integ.testsuite.dag.WriterContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.dag.scheduler.DagScheduler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class SaferSchemaDagScheduler
extends DagScheduler {
    private static Logger LOG = LogManager.getLogger(SaferSchemaDagScheduler.class);
    int processedVersion;

    public SaferSchemaDagScheduler(WorkflowDag workflowDag, WriterContext writerContext, JavaSparkContext jsc) {
        super(workflowDag, writerContext, jsc);
    }

    public SaferSchemaDagScheduler(WorkflowDag workflowDag, WriterContext writerContext, JavaSparkContext jsc, int version) {
        super(workflowDag, writerContext, jsc);
        this.processedVersion = version;
    }

    @Override
    protected void executeNode(DagNode node, int curRound) throws HoodieException {
        if (node.getConfig().getSchemaVersion() < this.processedVersion) {
            LOG.info((Object)String.format("----------------- Processed SaferSchema version %d is available.  Skipping redundant Insert Operation. (Processed = %d) -----------------", node.getConfig().getSchemaVersion(), this.processedVersion));
            return;
        }
        super.executeNode(node, curRound);
    }
}

