/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.utils;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkSqlUtils$ {
    public static SparkSqlUtils$ MODULE$;

    static {
        new SparkSqlUtils$();
    }

    public StructType getTableSchema(SparkSession sparkSession, String tableName) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSession.table(tableName).schema().fields())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SparkSqlUtils$.$anonfun$getTableSchema$1(field))));
    }

    public String convertAvroToSqlSchemaExpression(String avroSchemaString, Set<String> partitionColumns) {
        Tuple2<String, String>[] fields = this.getFieldNamesAndTypes(avroSchemaString);
        Tuple2[] reorderedFields = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SparkSqlUtils$.$anonfun$convertAvroToSqlSchemaExpression$1(partitionColumns, field))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains(field._1()))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])reorderedFields)).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append((String)e._1()).append(" ").append(e._2()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",\n");
    }

    public String[] convertAvroToFieldNames(String avroSchemaString) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getFieldNamesAndTypes(avroSchemaString))).map((Function1 & Serializable & scala.Serializable)e -> (String)e._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public Tuple2<String, String>[] getFieldNamesAndTypes(String avroSchemaString) {
        Schema schema = new Schema.Parser().parse(avroSchemaString);
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType().simpleString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void logQuery(Logger log, String query) {
        log.warn("----- Running the following Spark SQL query -----");
        log.warn(query);
        log.warn(new StringOps(Predef$.MODULE$.augmentString("-")).$times(50));
    }

    public String constructSelectQuery(String inputSchema, Set<String> partitionColumns, String tableName) {
        String[] fieldNames = this.convertAvroToFieldNames(inputSchema);
        String[] reorderedFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkSqlUtils$.$anonfun$constructSelectQuery$1(partitionColumns, name))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains((Object)name))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return this.constructSelectQuery(reorderedFieldNames, tableName);
    }

    public String constructSelectQuery(StructType structType, String tableName) {
        return this.constructSelectQuery(structType, (Set<String>)Predef$.MODULE$.Set().empty(), tableName);
    }

    public String constructSelectQuery(StructType structType, Set<String> partitionColumns, String tableName) {
        String[] fieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> field.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] reorderedFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkSqlUtils$.$anonfun$constructSelectQuery$4(partitionColumns, name))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)partitionColumns.contains((Object)name))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return this.constructSelectQuery(reorderedFieldNames, tableName);
    }

    public String constructSelectQuery(String[] fieldNames, String tableName) {
        scala.collection.mutable.StringBuilder selectQueryBuilder = new scala.collection.mutable.StringBuilder("select ");
        selectQueryBuilder.append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).mkString(", "));
        selectQueryBuilder.append(" from ");
        selectQueryBuilder.append(tableName);
        return selectQueryBuilder.toString();
    }

    public String constructCreateTableQuery(DeltaConfig.Config config, String targetTableName, String targetBasePath, String inputSchema, String inputTableName) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Set partitionColumns;
        scala.collection.mutable.StringBuilder createTableQueryBuilder = new scala.collection.mutable.StringBuilder("create table ");
        createTableQueryBuilder.append(targetTableName);
        Set set = partitionColumns = config.getPartitionField().isPresent() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)config.getPartitionField().get()})) : Predef$.MODULE$.Set().empty();
        if (!config.shouldUseCtas()) {
            createTableQueryBuilder.append(" (");
            createTableQueryBuilder.append(this.convertAvroToSqlSchemaExpression(inputSchema, (Set<String>)partitionColumns));
            boxedUnit2 = createTableQueryBuilder.append("\n)");
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        createTableQueryBuilder.append(" using hudi");
        Option<String> tableTypeOption = config.getTableType();
        Option<String> primaryKeyOption = config.getPrimaryKey();
        Option<String> preCombineFieldOption = config.getPreCombineField();
        Object object = config.isTableExternal() ? createTableQueryBuilder.append(new StringBuilder(12).append("\nlocation '").append(targetBasePath).append("'").toString()) : BoxedUnit.UNIT;
        String[] options = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        if (tableTypeOption.isPresent()) {
            options = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).$colon$plus((Object)new StringBuilder(9).append("type = '").append(tableTypeOption.get()).append("'").toString(), ClassTag$.MODULE$.apply(String.class));
        }
        if (primaryKeyOption.isPresent()) {
            options = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).$colon$plus((Object)new StringBuilder(15).append("primaryKey = '").append(primaryKeyOption.get()).append("'").toString(), ClassTag$.MODULE$.apply(String.class));
        }
        if (preCombineFieldOption.isPresent()) {
            options = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).$colon$plus((Object)new StringBuilder(20).append("preCombineField = '").append(preCombineFieldOption.get()).append("'").toString(), ClassTag$.MODULE$.apply(String.class));
        }
        Object object2 = options.length > 0 ? createTableQueryBuilder.append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).mkString("\noptions ( \n", ",\n", "\n)")) : BoxedUnit.UNIT;
        Option<String> partitionFieldOption = config.getPartitionField();
        Object object3 = partitionFieldOption.isPresent() ? createTableQueryBuilder.append(new StringBuilder(18).append("\npartitioned by (").append(partitionFieldOption.get()).append(")").toString()) : BoxedUnit.UNIT;
        if (config.shouldUseCtas()) {
            createTableQueryBuilder.append("\nas\n");
            boxedUnit = createTableQueryBuilder.append(this.constructSelectQuery(inputSchema, (Set<String>)partitionColumns, inputTableName));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return createTableQueryBuilder.toString();
    }

    public String constructInsertQuery(String insertType, String targetTableName, StructType schema, String inputTableName) {
        scala.collection.mutable.StringBuilder insertQueryBuilder = new scala.collection.mutable.StringBuilder("insert ");
        insertQueryBuilder.append(insertType);
        insertQueryBuilder.append(" ");
        insertQueryBuilder.append(targetTableName);
        insertQueryBuilder.append(" ");
        insertQueryBuilder.append(this.constructSelectQuery(schema, inputTableName));
        return insertQueryBuilder.toString();
    }

    public String constructMergeQuery(DeltaConfig.Config config, String targetTableName, StructType schema, String inputTableName) {
        scala.collection.mutable.StringBuilder mergeQueryBuilder = new scala.collection.mutable.StringBuilder("merge into ");
        mergeQueryBuilder.append(targetTableName);
        mergeQueryBuilder.append(" as target using (\n");
        mergeQueryBuilder.append(this.constructSelectQuery(schema, inputTableName));
        mergeQueryBuilder.append("\n) source\non ");
        mergeQueryBuilder.append(config.getMergeCondition());
        mergeQueryBuilder.append("\nwhen matched then ");
        mergeQueryBuilder.append(config.getMatchedAction());
        mergeQueryBuilder.append("\nwhen not matched then ");
        mergeQueryBuilder.append(config.getNotMatchedAction());
        return mergeQueryBuilder.toString();
    }

    public String constructUpdateQuery(DeltaConfig.Config config, SparkSession sparkSession, String targetTableName) {
        Tuple2<Object, Object> bounds = this.getLowerUpperBoundsFromPercentiles(config, sparkSession, targetTableName);
        scala.collection.mutable.StringBuilder updateQueryBuilder = new scala.collection.mutable.StringBuilder("update ");
        updateQueryBuilder.append(targetTableName);
        updateQueryBuilder.append(" set ");
        updateQueryBuilder.append(config.getUpdateColumn());
        updateQueryBuilder.append(" = ");
        updateQueryBuilder.append(config.getUpdateColumn());
        updateQueryBuilder.append(" * 1.6 ");
        updateQueryBuilder.append(" where ");
        updateQueryBuilder.append(config.getWhereConditionColumn());
        updateQueryBuilder.append(" between ");
        updateQueryBuilder.append(bounds._1$mcD$sp());
        updateQueryBuilder.append(" and ");
        updateQueryBuilder.append(bounds._2$mcD$sp());
        return updateQueryBuilder.toString();
    }

    public String constructDeleteQuery(DeltaConfig.Config config, SparkSession sparkSession, String targetTableName) {
        Tuple2<Object, Object> bounds = this.getLowerUpperBoundsFromPercentiles(config, sparkSession, targetTableName);
        scala.collection.mutable.StringBuilder deleteQueryBuilder = new scala.collection.mutable.StringBuilder("delete from ");
        deleteQueryBuilder.append(targetTableName);
        deleteQueryBuilder.append(" where ");
        deleteQueryBuilder.append(config.getWhereConditionColumn());
        deleteQueryBuilder.append(" between ");
        deleteQueryBuilder.append(bounds._1$mcD$sp());
        deleteQueryBuilder.append(" and ");
        deleteQueryBuilder.append(bounds._2$mcD$sp());
        return deleteQueryBuilder.toString();
    }

    public Tuple2<Object, Object> generatePercentiles(DeltaConfig.Config config) {
        double ratio = config.getRatioRecordsChange();
        return new Tuple2.mcDD.sp(Math.max(0.5 - ratio / 2.0, 0.0), Math.min(0.5 + ratio / 2.0, 1.0));
    }

    public double roundDouble(double number, Enumeration.Value mode) {
        return package$.MODULE$.BigDecimal().apply(number).setScale(4, mode).toDouble();
    }

    public Tuple2<Object, Object> getLowerUpperBoundsFromPercentiles(DeltaConfig.Config config, SparkSession sparkSession, String targetTableName) {
        Tuple2<Object, Object> percentiles = this.generatePercentiles(config);
        Row result = ((Row[])sparkSession.sql(this.constructPercentileQuery(config, targetTableName, percentiles)).collect())[0];
        return new Tuple2.mcDD.sp(this.roundDouble(BoxesRunTime.unboxToDouble((Object)result.get(0)), BigDecimal.RoundingMode$.MODULE$.HALF_DOWN()), this.roundDouble(BoxesRunTime.unboxToDouble((Object)result.get(1)), BigDecimal.RoundingMode$.MODULE$.HALF_UP()));
    }

    public String constructPercentileQuery(DeltaConfig.Config config, String targetTableName, Tuple2<Object, Object> percentiles) {
        scala.collection.mutable.StringBuilder percentileQueryBuilder = new scala.collection.mutable.StringBuilder("select percentile(");
        percentileQueryBuilder.append(config.getWhereConditionColumn());
        percentileQueryBuilder.append(", ");
        percentileQueryBuilder.append(percentiles._1$mcD$sp());
        percentileQueryBuilder.append("), percentile(");
        percentileQueryBuilder.append(config.getWhereConditionColumn());
        percentileQueryBuilder.append(", ");
        percentileQueryBuilder.append(percentiles._2$mcD$sp());
        percentileQueryBuilder.append(") from ");
        percentileQueryBuilder.append(targetTableName);
        return percentileQueryBuilder.toString();
    }

    public String constructChangedRecordQuery(DeltaConfig.Config config, String targetTableName, String avroSchemaString, double lowerBound, double upperBound) {
        scala.collection.mutable.StringBuilder recordQueryBuilder = new scala.collection.mutable.StringBuilder(this.constructSelectQuery(avroSchemaString, (Set<String>)Predef$.MODULE$.Set().empty(), targetTableName));
        recordQueryBuilder.append(" where ");
        recordQueryBuilder.append(config.getWhereConditionColumn());
        recordQueryBuilder.append(" between ");
        recordQueryBuilder.append(lowerBound);
        recordQueryBuilder.append(" and ");
        recordQueryBuilder.append(upperBound);
        return recordQueryBuilder.toString();
    }

    public JavaRDD<GenericRecord> generateUpdateRecords(DeltaConfig.Config config, SparkSession sparkSession, String avroSchemaString, String targetTableName, int parallelism) {
        Tuple2<Object, Object> bounds = this.getLowerUpperBoundsFromPercentiles(config, sparkSession, targetTableName);
        Dataset rows = sparkSession.sql(this.constructChangedRecordQuery(config, targetTableName, avroSchemaString, bounds._1$mcD$sp(), bounds._2$mcD$sp()));
        JavaRDD rdd = HoodieSparkUtils$.MODULE$.createRdd(rows, "hoodie_source", "hoodie.source", false, Option.empty()).map((Function1 & Serializable & scala.Serializable)record -> {
            record.put(config.getUpdateColumn(), (Object)BoxesRunTime.boxToDouble((double)(new StringOps(Predef$.MODULE$.augmentString(record.get(config.getUpdateColumn()).toString())).toDouble() * 1.6)));
            return record;
        }, ClassTag$.MODULE$.apply(GenericRecord.class)).toJavaRDD();
        JavaRDD repartitionedRdd = rdd.repartition(parallelism);
        repartitionedRdd.persist(StorageLevel$.MODULE$.DISK_ONLY());
        return repartitionedRdd;
    }

    public JavaRDD<GenericRecord> generateDeleteRecords(DeltaConfig.Config config, SparkSession sparkSession, String avroSchemaString, String targetTableName, int parallelism) {
        Tuple2<Object, Object> bounds = this.getLowerUpperBoundsFromPercentiles(config, sparkSession, targetTableName);
        Dataset rows = sparkSession.sql(this.constructChangedRecordQuery(config, targetTableName, avroSchemaString, bounds._1$mcD$sp(), bounds._2$mcD$sp()));
        JavaRDD rdd = HoodieSparkUtils$.MODULE$.createRdd(rows, "hoodie_source", "hoodie.source", false, Option.empty()).map((Function1 & Serializable & scala.Serializable)record -> {
            record.put("_hoodie_is_deleted", (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return record;
        }, ClassTag$.MODULE$.apply(GenericRecord.class)).toJavaRDD();
        JavaRDD repartitionedRdd = rdd.repartition(parallelism);
        repartitionedRdd.persist(StorageLevel$.MODULE$.DISK_ONLY());
        return repartitionedRdd;
    }

    public static final /* synthetic */ boolean $anonfun$getTableSchema$1(StructField field) {
        return !HoodieRecord.HOODIE_META_COLUMNS.contains(field.name());
    }

    public static final /* synthetic */ boolean $anonfun$convertAvroToSqlSchemaExpression$1(Set partitionColumns$1, Tuple2 field) {
        return !partitionColumns$1.contains(field._1());
    }

    public static final /* synthetic */ boolean $anonfun$constructSelectQuery$1(Set partitionColumns$2, String name) {
        return !partitionColumns$2.contains((Object)name);
    }

    public static final /* synthetic */ boolean $anonfun$constructSelectQuery$4(Set partitionColumns$3, String name) {
        return !partitionColumns$3.contains((Object)name);
    }

    private SparkSqlUtils$() {
        MODULE$ = this;
    }
}

