/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.writer;

import java.io.IOException;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.integ.testsuite.configuration.DFSDeltaConfig;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.writer.AvroFileDeltaInputWriter;
import org.apache.hudi.integ.testsuite.writer.DFSDeltaWriterAdapter;
import org.apache.hudi.integ.testsuite.writer.DeltaWriterAdapter;

public class DeltaWriterFactory {
    private DeltaWriterFactory() {
    }

    public static DeltaWriterAdapter getDeltaWriterAdapter(DeltaConfig config, Integer batchId) throws IOException {
        switch (config.getDeltaOutputMode()) {
            case DFS: {
                switch (config.getDeltaInputType()) {
                    case AVRO: {
                        DFSDeltaConfig dfsDeltaConfig = (DFSDeltaConfig)config;
                        dfsDeltaConfig.setBatchId(batchId);
                        AvroFileDeltaInputWriter fileDeltaInputGenerator = new AvroFileDeltaInputWriter(dfsDeltaConfig.getConfiguration(), StringUtils.join((String[])new String[]{dfsDeltaConfig.getDeltaBasePath(), dfsDeltaConfig.getBatchId().toString()}, (String)"/"), dfsDeltaConfig.getSchemaStr(), dfsDeltaConfig.getMaxFileSize());
                        return new DFSDeltaWriterAdapter(fileDeltaInputGenerator, batchId);
                    }
                }
                throw new IllegalArgumentException("Invalid delta input format " + (Object)((Object)config.getDeltaInputType()));
            }
        }
        throw new IllegalArgumentException("Invalid delta input type " + (Object)((Object)config.getDeltaOutputMode()));
    }
}

