/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.HoodieReadClient;
import org.apache.hudi.client.HoodieWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.integ.testsuite.HoodieDeltaStreamerWrapper;
import org.apache.hudi.integ.testsuite.HoodieTestSuiteJob;
import org.apache.hudi.integ.testsuite.dag.nodes.CleanNode;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.dag.nodes.RollbackNode;
import org.apache.hudi.integ.testsuite.dag.nodes.ScheduleCompactNode;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieTestSuiteWriter {
    private HoodieDeltaStreamerWrapper deltaStreamerWrapper;
    private HoodieWriteClient writeClient;
    protected HoodieTestSuiteJob.HoodieTestSuiteConfig cfg;
    private Option<String> lastCheckpoint;
    private HoodieReadClient hoodieReadClient;
    private Properties props;
    private String schema;
    private transient Configuration configuration;
    private transient JavaSparkContext sparkContext;
    private static Set<String> VALID_DAG_NODES_TO_ALLOW_WRITE_CLIENT_IN_DELTASTREAMER_MODE = new HashSet<String>(Arrays.asList(RollbackNode.class.getName(), CleanNode.class.getName(), ScheduleCompactNode.class.getName()));

    public HoodieTestSuiteWriter(JavaSparkContext jsc, Properties props, HoodieTestSuiteJob.HoodieTestSuiteConfig cfg, String schema) throws Exception {
        this(jsc, props, cfg, schema, true);
    }

    public HoodieTestSuiteWriter(JavaSparkContext jsc, Properties props, HoodieTestSuiteJob.HoodieTestSuiteConfig cfg, String schema, boolean rollbackInflight) throws Exception {
        this.deltaStreamerWrapper = new HoodieDeltaStreamerWrapper(cfg, jsc);
        this.hoodieReadClient = new HoodieReadClient(jsc, cfg.targetBasePath);
        if (!cfg.useDeltaStreamer.booleanValue()) {
            this.writeClient = new HoodieWriteClient(jsc, this.getHoodieClientConfig(cfg, props, schema), rollbackInflight);
        }
        this.cfg = cfg;
        this.configuration = jsc.hadoopConfiguration();
        this.sparkContext = jsc;
        this.props = props;
        this.schema = schema;
    }

    private HoodieWriteConfig getHoodieClientConfig(HoodieTestSuiteJob.HoodieTestSuiteConfig cfg, Properties props, String schema) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(cfg.targetBasePath).withAutoCommit(false).withCompactionConfig(HoodieCompactionConfig.newBuilder().withPayloadClass(cfg.payloadClassName).build()).forTable(cfg.targetTableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withProps((Map)props);
        builder = builder.withSchema(schema);
        return builder.build();
    }

    private boolean allowWriteClientAccess(DagNode dagNode) {
        return VALID_DAG_NODES_TO_ALLOW_WRITE_CLIENT_IN_DELTASTREAMER_MODE.contains(dagNode.getClass().getName());
    }

    public Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> fetchSource() throws Exception {
        return this.deltaStreamerWrapper.fetchSource();
    }

    public Option<String> startCommit() {
        if (this.cfg.useDeltaStreamer.booleanValue()) {
            return Option.of((Object)HoodieActiveTimeline.createNewInstantTime());
        }
        return Option.of((Object)this.writeClient.startCommit());
    }

    public JavaRDD<WriteStatus> upsert(Option<String> instantTime) throws Exception {
        if (this.cfg.useDeltaStreamer.booleanValue()) {
            return this.deltaStreamerWrapper.upsert(HoodieDeltaStreamer.Operation.UPSERT);
        }
        Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> nextBatch = this.fetchSource();
        this.lastCheckpoint = Option.of((Object)((Pair)nextBatch.getValue()).getLeft());
        return this.writeClient.upsert((JavaRDD)((Pair)nextBatch.getRight()).getRight(), (String)instantTime.get());
    }

    public JavaRDD<WriteStatus> insert(Option<String> instantTime) throws Exception {
        if (this.cfg.useDeltaStreamer.booleanValue()) {
            return this.deltaStreamerWrapper.insert();
        }
        Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> nextBatch = this.fetchSource();
        this.lastCheckpoint = Option.of((Object)((Pair)nextBatch.getValue()).getLeft());
        return this.writeClient.insert((JavaRDD)((Pair)nextBatch.getRight()).getRight(), (String)instantTime.get());
    }

    public JavaRDD<WriteStatus> bulkInsert(Option<String> instantTime) throws Exception {
        if (this.cfg.useDeltaStreamer.booleanValue()) {
            return this.deltaStreamerWrapper.bulkInsert();
        }
        Pair<SchemaProvider, Pair<String, JavaRDD<HoodieRecord>>> nextBatch = this.fetchSource();
        this.lastCheckpoint = Option.of((Object)((Pair)nextBatch.getValue()).getLeft());
        return this.writeClient.bulkInsert((JavaRDD)((Pair)nextBatch.getRight()).getRight(), (String)instantTime.get());
    }

    public JavaRDD<WriteStatus> compact(Option<String> instantTime) throws Exception {
        Option compactionPlanPair;
        if (this.cfg.useDeltaStreamer.booleanValue()) {
            return this.deltaStreamerWrapper.compact();
        }
        if (!instantTime.isPresent() && (compactionPlanPair = Option.fromJavaOptional(this.hoodieReadClient.getPendingCompactions().stream().findFirst())).isPresent()) {
            instantTime = Option.of((Object)((Pair)compactionPlanPair.get()).getLeft());
        }
        if (instantTime.isPresent()) {
            return this.writeClient.compact((String)instantTime.get());
        }
        return null;
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> previousCommitExtraMetadata) throws Exception {
        if (!this.cfg.useDeltaStreamer.booleanValue()) {
            this.deltaStreamerWrapper.scheduleCompact();
            return Option.empty();
        }
        return this.writeClient.scheduleCompaction(previousCommitExtraMetadata);
    }

    public void commit(JavaRDD<WriteStatus> records, Option<String> instantTime) {
        if (!this.cfg.useDeltaStreamer.booleanValue()) {
            HashMap<String, Object> extraMetadata = new HashMap<String, Object>();
            extraMetadata.put("deltastreamer.checkpoint.key", this.lastCheckpoint.get());
            this.writeClient.commit((String)instantTime.get(), records, Option.of(extraMetadata));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoodieWriteClient getWriteClient(DagNode dagNode) throws IllegalAccessException {
        if (this.cfg.useDeltaStreamer & !this.allowWriteClientAccess(dagNode)) {
            throw new IllegalAccessException("cannot access write client when testing in deltastreamer mode");
        }
        HoodieTestSuiteWriter hoodieTestSuiteWriter = this;
        synchronized (hoodieTestSuiteWriter) {
            if (this.writeClient == null) {
                this.writeClient = new HoodieWriteClient(this.sparkContext, this.getHoodieClientConfig(this.cfg, this.props, this.schema), false);
            }
        }
        return this.writeClient;
    }

    public HoodieDeltaStreamerWrapper getDeltaStreamerWrapper() {
        return this.deltaStreamerWrapper;
    }

    public HoodieTestSuiteJob.HoodieTestSuiteConfig getCfg() {
        return this.cfg;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JavaSparkContext getSparkContext() {
        return this.sparkContext;
    }
}

