/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DagNode<O>
implements Comparable<DagNode<O>> {
    protected static Logger log = LoggerFactory.getLogger(DagNode.class);
    protected List<DagNode<O>> childNodes;
    protected List<DagNode<O>> parentNodes;
    protected O result;
    protected DeltaConfig.Config config;
    private boolean isCompleted;

    public DagNode<O> addChildNode(DagNode childNode) {
        childNode.getParentNodes().add(this);
        this.getChildNodes().add(childNode);
        return this;
    }

    public DagNode<O> addParentNode(DagNode parentNode) {
        if (!this.getParentNodes().contains(parentNode)) {
            this.getParentNodes().add(parentNode);
        }
        return this;
    }

    public O getResult() {
        return this.result;
    }

    public List<DagNode<O>> getChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new LinkedList<DagNode<O>>();
        }
        return this.childNodes;
    }

    public List<DagNode<O>> getParentNodes() {
        if (this.parentNodes == null) {
            this.parentNodes = new ArrayList<DagNode<O>>();
        }
        return this.parentNodes;
    }

    public void setParentNodes(List<DagNode<O>> parentNodes) {
        this.parentNodes = parentNodes;
    }

    public abstract void execute(ExecutionContext var1) throws Exception;

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public DeltaConfig.Config getConfig() {
        return this.config;
    }

    public String getName() {
        Object name = this.config.getOtherConfigs().get("name");
        if (name == null) {
            String randomName = UUID.randomUUID().toString();
            this.config.getOtherConfigs().put("name", randomName);
            return randomName;
        }
        return name.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DagNode dagNode = (DagNode)o;
        return this.getName() == dagNode.getName();
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public int compareTo(DagNode<O> thatNode) {
        return this.hashCode() - thatNode.hashCode();
    }
}

