/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.HoodieTestSuiteWriter;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.generator.DeltaGenerator;
import org.apache.spark.api.java.JavaRDD;

public class InsertNode
extends DagNode<JavaRDD<WriteStatus>> {
    public InsertNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        this.generate(executionContext.getDeltaGenerator());
        log.info("Configs : {}", (Object)this.config);
        if (!this.config.isDisableIngest()) {
            log.info("Inserting input data {}", (Object)this.getName());
            Option<String> commitTime = executionContext.getHoodieTestSuiteWriter().startCommit();
            JavaRDD<WriteStatus> writeStatus = this.ingest(executionContext.getHoodieTestSuiteWriter(), commitTime);
            executionContext.getHoodieTestSuiteWriter().commit(writeStatus, commitTime);
            this.result = writeStatus;
        }
    }

    protected void generate(DeltaGenerator deltaGenerator) throws Exception {
        if (!this.config.isDisableGenerate()) {
            log.info("Generating input data for node {}", (Object)this.getName());
            deltaGenerator.writeRecords(deltaGenerator.generateInserts(this.config)).count();
        }
    }

    protected JavaRDD<WriteStatus> ingest(HoodieTestSuiteWriter hoodieTestSuiteWriter, Option<String> commitTime) throws Exception {
        return hoodieTestSuiteWriter.insert(commitTime);
    }
}

