/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;

public class RollbackNode
extends DagNode<Option<HoodieInstant>> {
    public RollbackNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        log.info("Executing rollback node {}", (Object)this.getName());
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(executionContext.getHoodieTestSuiteWriter().getConfiguration(), executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
        Option lastInstant = metaClient.getActiveTimeline().getCommitsTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            log.info("Rolling back last instant {}", lastInstant.get());
            executionContext.getHoodieTestSuiteWriter().getWriteClient(this).rollback(((HoodieInstant)lastInstant.get()).getTimestamp());
            this.result = lastInstant;
        }
    }
}

