/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadGenerator;

public class FlexibleSchemaRecordGenerationIterator
implements Iterator<GenericRecord> {
    private long counter;
    private GenericRecordFullPayloadGenerator generator;
    private GenericRecord lastRecord;
    private List<String> partitionPathFieldNames;

    public FlexibleSchemaRecordGenerationIterator(long maxEntriesToProduce, String schema) {
        this(maxEntriesToProduce, 10240, schema, null);
    }

    public FlexibleSchemaRecordGenerationIterator(long maxEntriesToProduce, int minPayloadSize, String schemaStr, List<String> partitionPathFieldNames) {
        this.counter = maxEntriesToProduce;
        this.partitionPathFieldNames = partitionPathFieldNames;
        Schema schema = new Schema.Parser().parse(schemaStr);
        this.generator = new GenericRecordFullPayloadGenerator(schema, minPayloadSize);
    }

    @Override
    public boolean hasNext() {
        return this.counter > 0L;
    }

    @Override
    public GenericRecord next() {
        --this.counter;
        if (this.lastRecord == null) {
            GenericRecord record;
            this.lastRecord = record = this.generator.getNewPayload();
            return record;
        }
        return this.generator.randomize(this.lastRecord, this.partitionPathFieldNames);
    }
}

