/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRecordFullPayloadGenerator
implements Serializable {
    public static final int DEFAULT_PAYLOAD_SIZE = 10240;
    private static Logger log = LoggerFactory.getLogger(GenericRecordFullPayloadGenerator.class);
    protected final Random random = new Random();
    private final transient Schema baseSchema;
    private final transient GenericData genericData = new GenericData();
    private int numberOfBytesToAdd;
    private boolean shouldAddMore;
    private int numberOfComplexFields;
    private int estimatedFullPayloadSize;
    private static final String DECIMAL = "decimal";
    private static final String UUID_NAME = "uuid";
    private static final String DATE = "date";
    private static final String TIME_MILLIS = "time-millis";
    private static final String TIME_MICROS = "time-micros";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String TIMESTAMP_MICROS = "timestamp-micros";

    public GenericRecordFullPayloadGenerator(Schema schema) {
        this(schema, 10240);
    }

    public GenericRecordFullPayloadGenerator(Schema schema, int minPayloadSize) {
        Pair<Integer, Integer> sizeInfo = new GenericRecordFullPayloadSizeEstimator(schema).typeEstimateAndNumComplexFields();
        this.estimatedFullPayloadSize = (Integer)sizeInfo.getLeft();
        this.numberOfComplexFields = (Integer)sizeInfo.getRight();
        this.baseSchema = schema;
        boolean bl = this.shouldAddMore = this.estimatedFullPayloadSize < minPayloadSize;
        if (this.shouldAddMore) {
            this.numberOfBytesToAdd = minPayloadSize - this.estimatedFullPayloadSize;
            if (this.numberOfComplexFields < 1) {
                log.warn("The schema does not have any collections/complex fields. Cannot achieve minPayloadSize : {}", (Object)minPayloadSize);
            }
        }
    }

    protected static boolean isPrimitive(Schema localSchema) {
        return localSchema.getType() != Schema.Type.ARRAY && localSchema.getType() != Schema.Type.MAP && localSchema.getType() != Schema.Type.RECORD && localSchema.getType() != Schema.Type.UNION;
    }

    public GenericRecord getNewPayload() {
        return this.convert(this.baseSchema);
    }

    public GenericRecord getUpdatePayload(GenericRecord record, List<String> blacklistFields) {
        return this.randomize(record, blacklistFields);
    }

    protected GenericRecord convert(Schema schema) {
        GenericData.Record result = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            result.put(f.name(), this.typeConvert(f.schema()));
        }
        return result;
    }

    protected GenericRecord convertPartial(Schema schema) {
        GenericData.Record result = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            boolean setNull = this.random.nextBoolean();
            if (!setNull) {
                result.put(f.name(), this.typeConvert(f.schema()));
                continue;
            }
            result.put(f.name(), null);
        }
        return result;
    }

    protected GenericRecord randomize(GenericRecord record, List<String> blacklistFields) {
        for (Schema.Field f : record.getSchema().getFields()) {
            if (blacklistFields != null && blacklistFields.contains(f.name())) continue;
            record.put(f.name(), this.typeConvert(f.schema()));
        }
        return record;
    }

    private Object typeConvert(Schema schema) {
        Schema localSchema = schema;
        if (this.isOption(schema)) {
            localSchema = this.getNonNull(schema);
        }
        switch (localSchema.getType()) {
            case BOOLEAN: {
                return this.random.nextBoolean();
            }
            case DOUBLE: {
                return this.random.nextDouble();
            }
            case FLOAT: {
                return Float.valueOf(this.random.nextFloat());
            }
            case INT: {
                return this.random.nextInt();
            }
            case LONG: {
                return this.random.nextLong();
            }
            case STRING: {
                return UUID.randomUUID().toString();
            }
            case ENUM: {
                List enumSymbols = localSchema.getEnumSymbols();
                return new GenericData.EnumSymbol(localSchema, (String)enumSymbols.get(this.random.nextInt(enumSymbols.size() - 1)));
            }
            case RECORD: {
                return this.convert(localSchema);
            }
            case ARRAY: {
                Schema elementSchema = localSchema.getElementType();
                ArrayList<Object> listRes = new ArrayList<Object>();
                if (GenericRecordFullPayloadGenerator.isPrimitive(elementSchema) && this.shouldAddMore) {
                    for (int numEntriesToAdd = this.numEntriesToAdd(elementSchema); numEntriesToAdd > 0; --numEntriesToAdd) {
                        listRes.add(this.typeConvert(elementSchema));
                    }
                } else {
                    listRes.add(this.typeConvert(elementSchema));
                }
                return listRes;
            }
            case MAP: {
                Schema valueSchema = localSchema.getValueType();
                HashMap<String, Object> mapRes = new HashMap<String, Object>();
                if (GenericRecordFullPayloadGenerator.isPrimitive(valueSchema) && this.shouldAddMore) {
                    for (int numEntriesToAdd = this.numEntriesToAdd(valueSchema); numEntriesToAdd > 0; --numEntriesToAdd) {
                        mapRes.put(UUID.randomUUID().toString(), this.typeConvert(valueSchema));
                    }
                } else {
                    mapRes.put(UUID.randomUUID().toString(), this.typeConvert(valueSchema));
                }
                return mapRes;
            }
            case BYTES: {
                return ByteBuffer.wrap(UUID.randomUUID().toString().getBytes(Charset.defaultCharset()));
            }
            case FIXED: {
                return this.generateFixedType(localSchema);
            }
        }
        throw new IllegalArgumentException("Cannot handle type: " + localSchema.getType());
    }

    private Object generateFixedType(Schema localSchema) {
        GenericData.Fixed genericFixed = new GenericData.Fixed(localSchema);
        switch (localSchema.getLogicalType().getName()) {
            case "uuid": {
                genericFixed.bytes(UUID.randomUUID().toString().getBytes());
                return genericFixed;
            }
            case "decimal": {
                return genericFixed;
            }
            case "date": {
                return genericFixed;
            }
            case "time-millis": {
                return genericFixed;
            }
        }
        throw new IllegalArgumentException("Cannot handle type: " + localSchema.getLogicalType());
    }

    public boolean validate(GenericRecord record) {
        return this.genericData.validate(this.baseSchema, (Object)record);
    }

    protected boolean isOption(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    protected Schema getNonNull(Schema schema) {
        List types = schema.getTypes();
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }

    public int getEstimatedFullPayloadSize() {
        return this.estimatedFullPayloadSize;
    }

    private int getSize(Schema elementSchema) {
        switch (elementSchema.getType()) {
            case BOOLEAN: {
                return 1;
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case STRING: {
                return UUID.randomUUID().toString().length();
            }
            case ENUM: {
                return 1;
            }
            case BYTES: {
                return UUID.randomUUID().toString().length();
            }
            case FIXED: {
                return elementSchema.getFixedSize();
            }
        }
        throw new RuntimeException("Unknown type " + elementSchema.getType());
    }

    private int numEntriesToAdd(Schema elementSchema) {
        int primitiveDataTypeSize = this.getSize(elementSchema);
        int numEntriesToAdd = this.numberOfBytesToAdd / primitiveDataTypeSize;
        if (numEntriesToAdd % 10 > 0 && this.numberOfComplexFields > 1) {
            this.numberOfBytesToAdd -= (numEntriesToAdd /= 10) * primitiveDataTypeSize;
            this.shouldAddMore = true;
        } else {
            this.numberOfBytesToAdd = 0;
            this.shouldAddMore = false;
        }
        --this.numberOfComplexFields;
        return numEntriesToAdd;
    }
}

