/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadGenerator;

public class UpdateGeneratorIterator
implements Iterator<GenericRecord> {
    private GenericRecordFullPayloadGenerator generator;
    private List<String> blackListedFields;
    private Iterator<GenericRecord> itr;

    public UpdateGeneratorIterator(Iterator<GenericRecord> itr, String schemaStr, List<String> partitionPathFieldNames, List<String> recordKeyFieldNames, int minPayloadSize) {
        this.itr = itr;
        this.blackListedFields = new ArrayList<String>();
        this.blackListedFields.addAll(partitionPathFieldNames);
        this.blackListedFields.addAll(recordKeyFieldNames);
        Schema schema = new Schema.Parser().parse(schemaStr);
        this.generator = new GenericRecordFullPayloadGenerator(schema, minPayloadSize);
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public GenericRecord next() {
        GenericRecord newRecord = this.itr.next();
        return this.generator.randomize(newRecord, this.blackListedFields);
    }
}

