/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;

public class DFSTestSuitePathSelector
extends DFSPathSelector {
    public DFSTestSuitePathSelector(TypedProperties props, Configuration hadoopConf) {
        super(props, hadoopConf);
    }

    public Pair<Option<String>, String> getNextFilePathsAndMaxModificationTime(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            FileStatus[] fileStatuses;
            Integer nextBatchId;
            Integer lastBatchId;
            if (lastCheckpointStr.isPresent()) {
                lastBatchId = Integer.parseInt((String)lastCheckpointStr.get());
                nextBatchId = lastBatchId + 1;
            } else {
                lastBatchId = -1;
                nextBatchId = 0;
            }
            ArrayList<Object> eligibleFiles = new ArrayList<Object>();
            for (FileStatus fileStatus : fileStatuses = this.fs.globStatus(new Path(this.props.getString("hoodie.deltastreamer.source.dfs.root"), "*"))) {
                if (!fileStatus.isDirectory() || IGNORE_FILEPREFIX_LIST.stream().anyMatch(pfx -> fileStatus.getPath().getName().startsWith((String)pfx)) || fileStatus.getPath().getName().compareTo(lastBatchId.toString()) <= 0 || fileStatus.getPath().getName().compareTo(nextBatchId.toString()) > 0) continue;
                RemoteIterator files = this.fs.listFiles(fileStatus.getPath(), true);
                while (files.hasNext()) {
                    eligibleFiles.add(files.next());
                }
            }
            if (eligibleFiles.size() == 0) {
                return new ImmutablePair((Object)Option.empty(), lastCheckpointStr.orElseGet(() -> String.valueOf(Long.MIN_VALUE)));
            }
            String pathStr = eligibleFiles.stream().map(f -> f.getPath().toString()).collect(Collectors.joining(","));
            return new ImmutablePair((Object)Option.ofNullable((Object)pathStr), (Object)String.valueOf(nextBatchId));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to readAvro from source from checkpoint: " + lastCheckpointStr, ioe);
        }
    }
}

