/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.writer.DeltaInputWriter;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.apache.hudi.integ.testsuite.writer.DeltaWriterAdapter;

public class DFSDeltaWriterAdapter
implements DeltaWriterAdapter<GenericRecord> {
    private DeltaInputWriter deltaInputGenerator;
    private List<DeltaWriteStats> metrics = new ArrayList<DeltaWriteStats>();

    public DFSDeltaWriterAdapter(DeltaInputWriter<GenericRecord> deltaInputGenerator) {
        this.deltaInputGenerator = deltaInputGenerator;
    }

    @Override
    public List<DeltaWriteStats> write(Iterator<GenericRecord> input) throws IOException {
        while (input.hasNext()) {
            if (this.deltaInputGenerator.canWrite()) {
                this.deltaInputGenerator.writeData(input.next());
                continue;
            }
            if (!input.hasNext()) continue;
            this.rollOver();
        }
        this.close();
        return this.metrics;
    }

    public void rollOver() throws IOException {
        this.close();
        this.deltaInputGenerator = this.deltaInputGenerator.getNewWriter();
    }

    private void close() throws IOException {
        this.deltaInputGenerator.close();
        this.metrics.add(this.deltaInputGenerator.getDeltaWriteStats());
    }
}

