/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.WorkflowDag;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;

public class DagUtils {
    public static final String DAG_NAME = "dag_name";
    public static final String DAG_ROUNDS = "dag_rounds";
    public static final String DAG_INTERMITTENT_DELAY_MINS = "dag_intermittent_delay_mins";
    public static final String DAG_CONTENT = "dag_content";
    public static int DEFAULT_DAG_ROUNDS = 1;
    public static int DEFAULT_INTERMITTENT_DELAY_MINS = 10;
    public static String DEFAULT_DAG_NAME = "TestDagName";
    static final ObjectMapper MAPPER = new ObjectMapper();

    public static WorkflowDag convertYamlPathToDag(FileSystem fs, String path) throws IOException {
        FSDataInputStream is = fs.open(new Path(path));
        return DagUtils.convertYamlToDag(DagUtils.toString((InputStream)is));
    }

    public static WorkflowDag convertYamlToDag(String yaml) throws IOException {
        int dagRounds = DEFAULT_DAG_ROUNDS;
        int intermittentDelayMins = DEFAULT_INTERMITTENT_DELAY_MINS;
        String dagName = DEFAULT_DAG_NAME;
        HashMap<String, DagNode> allNodes = new HashMap<String, DagNode>();
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = yamlReader.readTree(yaml);
        Iterator itr = jsonNode.fields();
        while (itr.hasNext()) {
            String key;
            Map.Entry dagNode = (Map.Entry)itr.next();
            switch (key = (String)dagNode.getKey()) {
                case "dag_name": {
                    dagName = ((JsonNode)dagNode.getValue()).asText();
                    break;
                }
                case "dag_rounds": {
                    dagRounds = ((JsonNode)dagNode.getValue()).asInt();
                    break;
                }
                case "dag_intermittent_delay_mins": {
                    intermittentDelayMins = ((JsonNode)dagNode.getValue()).asInt();
                    break;
                }
                case "dag_content": {
                    JsonNode dagContent = (JsonNode)dagNode.getValue();
                    Iterator contentItr = dagContent.fields();
                    while (contentItr.hasNext()) {
                        Map.Entry dagContentNode = (Map.Entry)contentItr.next();
                        allNodes.put((String)dagContentNode.getKey(), DagUtils.convertJsonToDagNode(allNodes, (String)dagContentNode.getKey(), (JsonNode)dagContentNode.getValue()));
                    }
                    break;
                }
            }
        }
        return new WorkflowDag(dagName, dagRounds, intermittentDelayMins, DagUtils.findRootNodes(allNodes));
    }

    public static String convertDagToYaml(WorkflowDag dag) throws IOException {
        ObjectMapper yamlWriter = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES));
        ObjectNode yamlNode = MAPPER.createObjectNode();
        DagUtils.convertDagToYaml((JsonNode)yamlNode, dag.getNodeList());
        return yamlWriter.writerWithDefaultPrettyPrinter().writeValueAsString((Object)yamlNode);
    }

    private static void convertDagToYaml(JsonNode yamlNode, List<DagNode> dagNodes) throws IOException {
        for (DagNode dagNode : dagNodes) {
            String name = dagNode.getConfig().getOtherConfigs().getOrDefault("name", dagNode.getName()).toString();
            ((ObjectNode)yamlNode).put(name, DagUtils.convertDagNodeToJsonNode(dagNode));
            if (dagNode.getChildNodes().size() <= 0) continue;
            DagUtils.convertDagToYaml(yamlNode, dagNode.getChildNodes());
        }
    }

    private static DagNode convertJsonToDagNode(Map<String, DagNode> allNodes, String name, JsonNode node) throws IOException {
        String type = node.get("type").asText();
        DagNode retNode = DagUtils.convertJsonToDagNode(node, type, name);
        Arrays.asList(node.get("deps").textValue().split(",")).stream().forEach(dep -> {
            DagNode parentNode = (DagNode)allNodes.get(dep);
            if (parentNode != null) {
                parentNode.addChildNode(retNode);
            }
        });
        return retNode;
    }

    private static List<DagNode> findRootNodes(Map<String, DagNode> allNodes) {
        ArrayList<DagNode> rootNodes = new ArrayList<DagNode>();
        allNodes.entrySet().stream().forEach(entry -> {
            if (((DagNode)entry.getValue()).getParentNodes().size() < 1) {
                rootNodes.add((DagNode)entry.getValue());
            }
        });
        return rootNodes;
    }

    private static DagNode convertJsonToDagNode(JsonNode node, String type, String name) {
        try {
            DeltaConfig.Config config = DeltaConfig.Config.newBuilder().withConfigsMap(DagUtils.convertJsonNodeToMap(node)).withName(name).build();
            return (DagNode)ReflectionUtils.loadClass((String)DagUtils.generateFQN(type), (Object[])new Object[]{config});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String generateFQN(String name) throws ClassNotFoundException {
        return Class.forName(StringUtils.joinUsingDelim((String)".", (String[])new String[]{DagNode.class.getName().substring(0, DagNode.class.getName().lastIndexOf(".")), name})).getName();
    }

    private static JsonNode convertDagNodeToJsonNode(DagNode node) throws IOException {
        return DagUtils.createJsonNode(node, node.getClass().getSimpleName());
    }

    private static Map<String, Object> convertJsonNodeToMap(JsonNode node) {
        HashMap<String, Object> configsMap = new HashMap<String, Object>();
        Iterator itr = node.get("config").fields();
        block8: while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            switch ((String)entry.getKey()) {
                case "hive_queries": {
                    configsMap.put("hive_queries", DagUtils.getHiveQueries(entry));
                    continue block8;
                }
                case "hive_props": {
                    configsMap.put("hive_props", DagUtils.getProperties(entry));
                    continue block8;
                }
            }
            configsMap.put((String)entry.getKey(), DagUtils.getValue((JsonNode)entry.getValue()));
        }
        return configsMap;
    }

    private static List<Pair<String, Integer>> getHiveQueries(Map.Entry<String, JsonNode> entry) {
        ArrayList<Pair<String, Integer>> queries = new ArrayList<Pair<String, Integer>>();
        Iterator queriesItr = entry.getValue().fields();
        while (queriesItr.hasNext()) {
            queries.add((Pair<String, Integer>)Pair.of((Object)((JsonNode)((Map.Entry)queriesItr.next()).getValue()).textValue(), (Object)((JsonNode)((Map.Entry)queriesItr.next()).getValue()).asInt()));
        }
        return queries;
    }

    private static List<String> getProperties(Map.Entry<String, JsonNode> entry) {
        ArrayList<String> properties = new ArrayList<String>();
        Iterator queriesItr = entry.getValue().fields();
        while (queriesItr.hasNext()) {
            properties.add(((JsonNode)((Map.Entry)queriesItr.next()).getValue()).textValue());
        }
        return properties;
    }

    private static Object getValue(JsonNode node) {
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isShort()) {
            return node.asInt();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isFloat()) {
            return node.asDouble();
        }
        return node.textValue();
    }

    private static JsonNode createJsonNode(DagNode node, String type) throws IOException {
        JsonNode configNode = MAPPER.readTree(node.getConfig().toString());
        ObjectNode jsonNode = MAPPER.createObjectNode();
        jsonNode.put("config", configNode);
        jsonNode.put("type", type);
        jsonNode.put("deps", DagUtils.getDependencyNames(node));
        return jsonNode;
    }

    private static String getDependencyNames(DagNode node) {
        return node.getParentNodes().stream().map(e -> ((DagNode)e).getConfig().getOtherConfigs().getOrDefault("name", node.getName()).toString()).collect(Collectors.joining(",")).toString();
    }

    public static String toString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("utf-8");
    }
}

