/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.spark.api.java.JavaRDD;

public class CompactNode
extends DagNode<JavaRDD<WriteStatus>> {
    public CompactNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(executionContext.getHoodieTestSuiteWriter().getConfiguration(), executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
        Option lastInstant = metaClient.getActiveTimeline().getCommitsAndCompactionTimeline().filterPendingCompactionTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            log.info("Compacting instant {}", lastInstant.get());
            this.result = executionContext.getHoodieTestSuiteWriter().compact((Option<String>)Option.of((Object)((HoodieInstant)lastInstant.get()).getTimestamp()));
        }
    }
}

