/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.helpers.DFSTestSuitePathSelector;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;

public class RollbackNode
extends DagNode<Option<HoodieInstant>> {
    public RollbackNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        log.info("Executing rollback node {}", (Object)this.getName());
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(executionContext.getHoodieTestSuiteWriter().getConfiguration(), executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
        Option lastInstant = metaClient.getActiveTimeline().getCommitsTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            log.info("Rolling back last instant {}", lastInstant.get());
            log.info("Cleaning up generated data for the instant being rolled back {}", lastInstant.get());
            ValidationUtils.checkArgument((boolean)executionContext.getWriterContext().getProps().getOrDefault((Object)"hoodie.deltastreamer.source.input.selector", (Object)DFSPathSelector.class.getName()).toString().equalsIgnoreCase(DFSTestSuitePathSelector.class.getName()), (String)"Test Suite only supports DFSTestSuitePathSelector");
            executionContext.getHoodieTestSuiteWriter().getWriteClient(this).rollback(((HoodieInstant)lastInstant.get()).getTimestamp());
            metaClient.getFs().delete(new Path(executionContext.getWriterContext().getCfg().inputBasePath, (String)executionContext.getWriterContext().getHoodieTestSuiteWriter().getLastCheckpoint().orElse((Object)"")), true);
            this.result = lastInstant;
        }
    }
}

