/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;

public class ScheduleCompactNode
extends DagNode<Option<String>> {
    public ScheduleCompactNode(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        log.info("Executing schedule compact node {}", (Object)this.getName());
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(executionContext.getHoodieTestSuiteWriter().getConfiguration(), executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
        Option lastInstant = metaClient.getActiveTimeline().getCommitsTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails((HoodieInstant)lastInstant.get()).get()), HoodieCommitMetadata.class);
            Option<String> scheduledInstant = executionContext.getHoodieTestSuiteWriter().scheduleCompaction((Option<Map<String, String>>)Option.of((Object)metadata.getExtraMetadata()));
            if (scheduledInstant.isPresent()) {
                log.info("Scheduling compaction instant {}", scheduledInstant.get());
            }
            this.result = scheduledInstant;
        }
    }
}

