/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRecordFullPayloadGenerator
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(GenericRecordFullPayloadGenerator.class);
    public static final int DEFAULT_PAYLOAD_SIZE = 10240;
    public static final int DEFAULT_NUM_DATE_PARTITIONS = 50;
    public static final String DEFAULT_HOODIE_IS_DELETED_COL = "_hoodie_is_deleted";
    protected final Random random = new Random();
    private final transient Schema baseSchema;
    private final transient GenericData genericData = new GenericData();
    private int partitionIndex = 0;
    private int estimatedFullPayloadSize;
    Map<String, Integer> extraEntriesMap = new HashMap<String, Integer>();
    private int numDatePartitions = 50;
    private static final String DECIMAL = "decimal";
    private static final String UUID_NAME = "uuid";
    private static final String DATE = "date";
    private static final String TIME_MILLIS = "time-millis";
    private static final String TIME_MICROS = "time-micros";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String TIMESTAMP_MICROS = "timestamp-micros";

    public GenericRecordFullPayloadGenerator(Schema schema) {
        this(schema, 10240);
    }

    public GenericRecordFullPayloadGenerator(Schema schema, int minPayloadSize, int numDatePartitions) {
        this(schema, minPayloadSize);
        this.numDatePartitions = numDatePartitions;
    }

    public GenericRecordFullPayloadGenerator(Schema schema, int minPayloadSize) {
        Pair<Integer, Integer> sizeInfo = new GenericRecordFullPayloadSizeEstimator(schema).typeEstimateAndNumComplexFields();
        this.estimatedFullPayloadSize = (Integer)sizeInfo.getLeft();
        this.baseSchema = schema;
        if (this.estimatedFullPayloadSize < minPayloadSize) {
            int numberOfComplexFields = (Integer)sizeInfo.getRight();
            if (numberOfComplexFields < 1) {
                LOG.warn("The schema does not have any collections/complex fields. Cannot achieve minPayloadSize : {}", (Object)minPayloadSize);
            }
            this.determineExtraEntriesRequired(numberOfComplexFields, minPayloadSize - this.estimatedFullPayloadSize);
        }
    }

    protected static boolean isPrimitive(Schema localSchema) {
        return localSchema.getType() != Schema.Type.ARRAY && localSchema.getType() != Schema.Type.MAP && localSchema.getType() != Schema.Type.RECORD && localSchema.getType() != Schema.Type.UNION;
    }

    public GenericRecord getNewPayload() {
        return this.getNewPayload(this.baseSchema);
    }

    protected GenericRecord getNewPayload(Schema schema) {
        return this.create(schema, null);
    }

    public GenericRecord getNewPayload(Set<String> partitionPathFieldNames) {
        return this.create(this.baseSchema, partitionPathFieldNames);
    }

    public GenericRecord getNewPayloadWithTimestamp(String tsFieldName) {
        return this.updateTimestamp(this.create(this.baseSchema, null), tsFieldName);
    }

    public GenericRecord getUpdatePayloadWithTimestamp(GenericRecord record, Set<String> blacklistFields, String tsFieldName) {
        return this.updateTimestamp(this.randomize(record, blacklistFields), tsFieldName);
    }

    protected GenericRecord create(Schema schema, Set<String> partitionPathFieldNames) {
        GenericData.Record result = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            if (f.name().equals(DEFAULT_HOODIE_IS_DELETED_COL)) {
                result.put(f.name(), (Object)false);
                continue;
            }
            if (this.isPartialLongField(f, partitionPathFieldNames)) {
                long value = TimeUnit.SECONDS.convert(this.partitionIndex, TimeUnit.DAYS);
                result.put(f.name(), (Object)value);
                continue;
            }
            result.put(f.name(), this.typeConvert(f));
        }
        return result;
    }

    private boolean isPartialLongField(Schema.Field field, Set<String> partitionPathFieldNames) {
        if (partitionPathFieldNames == null || !partitionPathFieldNames.contains(field.name())) {
            return false;
        }
        Schema fieldSchema = field.schema();
        if (this.isOption(fieldSchema)) {
            fieldSchema = this.getNonNull(fieldSchema);
        }
        return fieldSchema.getType() == Schema.Type.LONG;
    }

    public GenericRecord getUpdatePayload(GenericRecord record, Set<String> blacklistFields) {
        return this.randomize(record, blacklistFields);
    }

    protected GenericRecord convertPartial(Schema schema) {
        GenericData.Record result = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            if (f.name().equals(DEFAULT_HOODIE_IS_DELETED_COL)) {
                result.put(f.name(), (Object)false);
                continue;
            }
            boolean setNull = this.random.nextBoolean();
            if (!setNull) {
                result.put(f.name(), this.typeConvert(f));
                continue;
            }
            result.put(f.name(), null);
        }
        return result;
    }

    protected GenericRecord randomize(GenericRecord record, Set<String> blacklistFields) {
        for (Schema.Field f : record.getSchema().getFields()) {
            if (f.name().equals(DEFAULT_HOODIE_IS_DELETED_COL)) {
                record.put(f.name(), (Object)false);
                continue;
            }
            if (blacklistFields != null && blacklistFields.contains(f.name())) continue;
            record.put(f.name(), this.typeConvert(f));
        }
        return record;
    }

    protected GenericRecord generateDeleteRecord(GenericRecord record) {
        record.put(DEFAULT_HOODIE_IS_DELETED_COL, (Object)true);
        return record;
    }

    private Object typeConvert(Schema.Field field) {
        Schema fieldSchema = field.schema();
        if (this.isOption(fieldSchema)) {
            fieldSchema = this.getNonNull(fieldSchema);
        }
        if (fieldSchema.getName().equals(DEFAULT_HOODIE_IS_DELETED_COL)) {
            return false;
        }
        switch (fieldSchema.getType()) {
            case BOOLEAN: {
                return this.random.nextBoolean();
            }
            case DOUBLE: {
                return this.random.nextDouble();
            }
            case FLOAT: {
                return Float.valueOf(this.random.nextFloat());
            }
            case INT: {
                return this.random.nextInt();
            }
            case LONG: {
                return this.random.nextLong();
            }
            case STRING: {
                return UUID.randomUUID().toString();
            }
            case ENUM: {
                List enumSymbols = fieldSchema.getEnumSymbols();
                return new GenericData.EnumSymbol(fieldSchema, (String)enumSymbols.get(this.random.nextInt(enumSymbols.size() - 1)));
            }
            case RECORD: {
                return this.getNewPayload(fieldSchema);
            }
            case ARRAY: {
                Schema.Field elementField = new Schema.Field(field.name(), fieldSchema.getElementType(), "", null);
                ArrayList<Object> listRes = new ArrayList<Object>();
                int numEntriesToAdd = this.extraEntriesMap.getOrDefault(field.name(), 1);
                while (numEntriesToAdd-- > 0) {
                    listRes.add(this.typeConvert(elementField));
                }
                return listRes;
            }
            case MAP: {
                Schema.Field valueField = new Schema.Field(field.name(), fieldSchema.getValueType(), "", null);
                HashMap<String, Object> mapRes = new HashMap<String, Object>();
                for (int numEntriesToAdd = this.extraEntriesMap.getOrDefault(field.name(), 1).intValue(); numEntriesToAdd > 0; --numEntriesToAdd) {
                    mapRes.put(UUID.randomUUID().toString(), this.typeConvert(valueField));
                }
                return mapRes;
            }
            case BYTES: {
                return ByteBuffer.wrap(UUID.randomUUID().toString().getBytes(Charset.defaultCharset()));
            }
            case FIXED: {
                return this.generateFixedType(fieldSchema);
            }
        }
        throw new IllegalArgumentException("Cannot handle type: " + fieldSchema.getType());
    }

    private Object generateFixedType(Schema localSchema) {
        GenericData.Fixed genericFixed = new GenericData.Fixed(localSchema);
        switch (localSchema.getLogicalType().getName()) {
            case "uuid": {
                genericFixed.bytes(UUID.randomUUID().toString().getBytes());
                return genericFixed;
            }
            case "decimal": {
                return genericFixed;
            }
            case "date": {
                return genericFixed;
            }
            case "time-millis": {
                return genericFixed;
            }
        }
        throw new IllegalArgumentException("Cannot handle type: " + localSchema.getLogicalType());
    }

    public boolean validate(GenericRecord record) {
        return this.genericData.validate(this.baseSchema, (Object)record);
    }

    public GenericRecord updateTimestamp(GenericRecord record, String fieldName) {
        long delta = TimeUnit.MILLISECONDS.convert(++this.partitionIndex % this.numDatePartitions, TimeUnit.DAYS);
        record.put(fieldName, (Object)(System.currentTimeMillis() - delta));
        return record;
    }

    protected boolean isOption(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    protected Schema getNonNull(Schema schema) {
        List types = schema.getTypes();
        return ((Schema)types.get(0)).getType().equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }

    public int getEstimatedFullPayloadSize() {
        return this.estimatedFullPayloadSize;
    }

    private int getSize(Schema elementSchema) {
        switch (elementSchema.getType()) {
            case BOOLEAN: {
                return 1;
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case STRING: {
                return UUID.randomUUID().toString().length();
            }
            case ENUM: {
                return 1;
            }
            case BYTES: {
                return UUID.randomUUID().toString().length();
            }
            case FIXED: {
                return elementSchema.getFixedSize();
            }
        }
        throw new RuntimeException("Unknown type " + elementSchema.getType());
    }

    private void determineExtraEntriesRequired(int numberOfComplexFields, int numberOfBytesToAdd) {
        for (Schema.Field f : this.baseSchema.getFields()) {
            Schema elementSchema = f.schema();
            int primitiveDataTypeSize = 0;
            if (elementSchema.getType() == Schema.Type.ARRAY && GenericRecordFullPayloadGenerator.isPrimitive(elementSchema.getElementType())) {
                primitiveDataTypeSize = this.getSize(elementSchema.getElementType());
            } else {
                if (elementSchema.getType() != Schema.Type.MAP || !GenericRecordFullPayloadGenerator.isPrimitive(elementSchema.getValueType())) continue;
                primitiveDataTypeSize = this.getSize(elementSchema.getValueType());
            }
            int numEntriesToAdd = numberOfBytesToAdd / primitiveDataTypeSize;
            if (numEntriesToAdd > 10 && numberOfComplexFields > 1) {
                numEntriesToAdd = 10;
                numberOfBytesToAdd -= numEntriesToAdd * primitiveDataTypeSize;
            } else {
                numberOfBytesToAdd = 0;
            }
            this.extraEntriesMap.put(f.name(), numEntriesToAdd);
            --numberOfComplexFields;
            if (numberOfBytesToAdd > 0) continue;
            break;
        }
    }
}

