/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.generator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.generator.GenericRecordFullPayloadGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateGeneratorIterator
implements Iterator<GenericRecord> {
    private static Logger LOG = LoggerFactory.getLogger(UpdateGeneratorIterator.class);
    private GenericRecordFullPayloadGenerator generator;
    private Set<String> blackListedFields;
    private Iterator<GenericRecord> itr;

    public UpdateGeneratorIterator(Iterator<GenericRecord> itr, String schemaStr, List<String> partitionPathFieldNames, List<String> recordKeyFieldNames, int minPayloadSize) {
        this.itr = itr;
        this.blackListedFields = new HashSet<String>();
        this.blackListedFields.addAll(partitionPathFieldNames);
        this.blackListedFields.addAll(recordKeyFieldNames);
        Schema schema = new Schema.Parser().parse(schemaStr);
        this.generator = new GenericRecordFullPayloadGenerator(schema, minPayloadSize);
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public GenericRecord next() {
        GenericRecord newRecord = this.itr.next();
        return this.generator.randomize(newRecord, this.blackListedFields);
    }
}

