/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.integ.testsuite.writer.DeltaInputWriter;
import org.apache.hudi.integ.testsuite.writer.DeltaWriteStats;
import org.apache.hudi.integ.testsuite.writer.DeltaWriterAdapter;

public class DFSDeltaWriterAdapter
implements DeltaWriterAdapter<GenericRecord> {
    private DeltaInputWriter deltaInputWriter;
    private List<DeltaWriteStats> metrics = new ArrayList<DeltaWriteStats>();
    private int preCombineFieldVal = 0;

    public DFSDeltaWriterAdapter(DeltaInputWriter<GenericRecord> deltaInputWriter, int preCombineFieldVal) {
        this.deltaInputWriter = deltaInputWriter;
        this.preCombineFieldVal = preCombineFieldVal;
    }

    public DFSDeltaWriterAdapter(DeltaInputWriter<GenericRecord> deltaInputWriter) {
        this.deltaInputWriter = deltaInputWriter;
    }

    @Override
    public List<DeltaWriteStats> write(Iterator<GenericRecord> input) throws IOException {
        while (input.hasNext()) {
            GenericRecord next = input.next();
            next.put("test_suite_source_ordering_field", (Object)this.preCombineFieldVal);
            if (this.deltaInputWriter.canWrite()) {
                this.deltaInputWriter.writeData(next);
                continue;
            }
            this.rollOver();
            this.deltaInputWriter.writeData(next);
        }
        this.close();
        return this.metrics;
    }

    public void rollOver() throws IOException {
        this.close();
        this.deltaInputWriter = this.deltaInputWriter.getNewWriter();
    }

    private void close() throws IOException {
        this.deltaInputWriter.close();
        this.metrics.add(this.deltaInputWriter.getDeltaWriteStats());
    }
}

