/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.helpers.HiveServiceProvider;

public class HiveSyncNode
extends DagNode<Boolean> {
    private HiveServiceProvider hiveServiceProvider;

    public HiveSyncNode(DeltaConfig.Config config) {
        this.config = config;
        this.hiveServiceProvider = new HiveServiceProvider(config);
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        log.info("Executing hive sync node");
        this.hiveServiceProvider.startLocalHiveServiceIfNeeded(executionContext.getHoodieTestSuiteWriter().getConfiguration());
        this.hiveServiceProvider.syncToLocalHiveIfNeeded(executionContext.getHoodieTestSuiteWriter());
        this.hiveServiceProvider.stopLocalHiveServiceIfNeeded();
    }

    public HiveServiceProvider getHiveServiceProvider() {
        return this.hiveServiceProvider;
    }
}

