/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.apache.hudi.integ.testsuite.helpers.HiveServiceProvider;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SparkSQLQueryNode
extends DagNode<Boolean> {
    HiveServiceProvider hiveServiceProvider;

    public SparkSQLQueryNode(DeltaConfig.Config config) {
        this.config = config;
        this.hiveServiceProvider = new HiveServiceProvider(config);
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        log.info("Executing spark sql query node");
        this.hiveServiceProvider.startLocalHiveServiceIfNeeded(executionContext.getHoodieTestSuiteWriter().getConfiguration());
        this.hiveServiceProvider.syncToLocalHiveIfNeeded(executionContext.getHoodieTestSuiteWriter());
        SparkSession session = SparkSession.builder().sparkContext(executionContext.getJsc().sc()).getOrCreate();
        for (String string : this.config.getHiveProperties()) {
            session.sql(string).count();
        }
        for (Pair pair : this.config.getHiveQueries()) {
            log.info("Running {}", pair.getLeft());
            Dataset res = session.sql((String)pair.getLeft());
            if (res.count() == 0L ? !$assertionsDisabled && 0 != (Integer)pair.getRight() : !$assertionsDisabled && ((Row[])res.collect())[0].getInt(0) != ((Integer)pair.getRight()).intValue()) {
                throw new AssertionError();
            }
            log.info("Successfully validated query!");
        }
        this.hiveServiceProvider.stopLocalHiveServiceIfNeeded();
        this.result = true;
    }
}

