/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.dag.nodes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.configuration.DeltaConfig;
import org.apache.hudi.integ.testsuite.dag.ExecutionContext;
import org.apache.hudi.integ.testsuite.dag.nodes.DagNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAsyncOperations
extends DagNode<Option<String>> {
    private static Logger log = LoggerFactory.getLogger(ValidateAsyncOperations.class);

    public ValidateAsyncOperations(DeltaConfig.Config config) {
        this.config = config;
    }

    @Override
    public void execute(ExecutionContext executionContext, int curItrCount) throws Exception {
        if (this.config.getIterationCountToExecute() == curItrCount) {
            try {
                log.warn("Executing ValidateHoodieAsyncOperations node {} with target base path {} ", (Object)this.getName(), (Object)executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath);
                String basePath = executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath;
                int maxCommitsRetained = executionContext.getHoodieTestSuiteWriter().getWriteConfig().getCleanerCommitsRetained() + 1;
                FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)executionContext.getHoodieTestSuiteWriter().getConfiguration());
                HashMap fileIdCount = new HashMap();
                AtomicInteger maxVal = new AtomicInteger();
                List partitionPaths = FSUtils.getAllPartitionFoldersThreeLevelsDown((FileSystem)fs, (String)basePath);
                for (String partitionPath : partitionPaths) {
                    List<FileStatus> fileStatuses = Arrays.stream(FSUtils.getAllDataFilesInPartition((FileSystem)fs, (Path)new Path(basePath + "/" + partitionPath))).collect(Collectors.toList());
                    fileStatuses.forEach(entry -> {
                        String fileId = FSUtils.getFileId((String)entry.getPath().getName());
                        fileIdCount.computeIfAbsent(fileId, k -> 0);
                        fileIdCount.put(fileId, (Integer)fileIdCount.get(fileId) + 1);
                        maxVal.set(Math.max(maxVal.get(), (Integer)fileIdCount.get(fileId)));
                    });
                }
                if (maxVal.get() > maxCommitsRetained) {
                    throw new AssertionError((Object)("Total commits (" + maxVal + ") retained exceeds max value of " + maxCommitsRetained + ", total commits : "));
                }
                if (this.config.validateArchival() || this.config.validateClean()) {
                    Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("\\.commits_\\.archive\\..*");
                    Pattern CLEAN_FILE_PATTERN = Pattern.compile(".*\\.clean\\..*");
                    String metadataPath = executionContext.getHoodieTestSuiteWriter().getCfg().targetBasePath + "/.hoodie";
                    FileStatus[] metaFileStatuses = fs.listStatus(new Path(metadataPath));
                    boolean archFound = false;
                    boolean cleanFound = false;
                    for (FileStatus fileStatus : metaFileStatuses) {
                        Matcher cleanFileMatcher;
                        Matcher archFileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileStatus.getPath().getName());
                        if (archFileMatcher.matches()) {
                            archFound = true;
                            if (this.config.validateArchival() && !this.config.validateClean()) break;
                        }
                        if ((cleanFileMatcher = CLEAN_FILE_PATTERN.matcher(fileStatus.getPath().getName())).matches()) {
                            cleanFound = true;
                            if (!this.config.validateArchival() && this.config.validateClean()) break;
                        }
                        if (this.config.validateClean() && this.config.validateArchival() && archFound && cleanFound) break;
                    }
                    if (this.config.validateArchival() && !archFound) {
                        throw new AssertionError((Object)("Archival NotFound in " + metadataPath));
                    }
                    if (this.config.validateClean() && !cleanFound) {
                        throw new AssertionError((Object)("Clean commits NotFound in " + metadataPath));
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception thrown in ValidateHoodieAsyncOperations Node :: " + e.getCause() + ", msg :: " + e.getMessage());
                throw e;
            }
        }
    }
}

