/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.schema;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.integ.testsuite.dag.WriterContext;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class TestSuiteFileBasedSchemaProvider
extends FilebasedSchemaProvider {
    protected static Logger log = LogManager.getLogger(WriterContext.class);

    public TestSuiteFileBasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        this.sourceSchema = this.addSourceOrderingFieldToSchema(this.sourceSchema);
        this.targetSchema = this.addSourceOrderingFieldToSchema(this.targetSchema);
    }

    private Schema addSourceOrderingFieldToSchema(Schema schema) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field field : schema.getFields()) {
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
            for (Map.Entry prop : field.getObjectProps().entrySet()) {
                newField.addProp((String)prop.getKey(), prop.getValue());
            }
            fields.add(newField);
        }
        Schema.Field sourceOrderingField = new Schema.Field("test_suite_source_ordering_field", Schema.create((Schema.Type)Schema.Type.INT), "", (Object)0);
        fields.add(sourceOrderingField);
        Schema mergedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false);
        mergedSchema.setFields(fields);
        return mergedSchema;
    }
}

