/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.integ.testsuite.HoodieTestSuiteJob;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSTestSuitePathSelector
extends DFSPathSelector {
    private static volatile Logger log = LoggerFactory.getLogger(HoodieTestSuiteJob.class);

    public DFSTestSuitePathSelector(TypedProperties props, Configuration hadoopConf) {
        super(props, hadoopConf);
    }

    public Pair<Option<String>, String> getNextFilePathsAndMaxModificationTime(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            Integer nextBatchId;
            Integer lastBatchId;
            if (lastCheckpointStr.isPresent()) {
                lastBatchId = Integer.parseInt((String)lastCheckpointStr.get());
                nextBatchId = lastBatchId + 1;
            } else {
                lastBatchId = 0;
                nextBatchId = 1;
            }
            ArrayList<Object> eligibleFiles = new ArrayList<Object>();
            FileStatus[] fileStatuses = this.fs.globStatus(new Path(this.props.getString("hoodie.deltastreamer.source.dfs.root"), "*"));
            Optional<String> correctBatchIdDueToRollback = Arrays.stream(fileStatuses).map(f -> f.getPath().toString().split("/")[f.getPath().toString().split("/").length - 1]).filter(bid1 -> Integer.parseInt(bid1) > lastBatchId).min((bid1, bid2) -> Integer.min(Integer.parseInt(bid1), Integer.parseInt(bid2)));
            if (correctBatchIdDueToRollback.isPresent() && Integer.parseInt(correctBatchIdDueToRollback.get()) > nextBatchId) {
                nextBatchId = Integer.parseInt(correctBatchIdDueToRollback.get());
            }
            log.info("Using DFSTestSuitePathSelector, checkpoint: " + lastCheckpointStr + " sourceLimit: " + sourceLimit + " lastBatchId: " + lastBatchId + " nextBatchId: " + nextBatchId);
            for (FileStatus fileStatus : fileStatuses) {
                if (!fileStatus.isDirectory() || IGNORE_FILEPREFIX_LIST.stream().anyMatch(pfx -> fileStatus.getPath().getName().startsWith((String)pfx)) || Integer.parseInt(fileStatus.getPath().getName()) <= lastBatchId || Integer.parseInt(fileStatus.getPath().getName()) > nextBatchId) continue;
                RemoteIterator files = this.fs.listFiles(fileStatus.getPath(), true);
                while (files.hasNext()) {
                    eligibleFiles.add(files.next());
                }
            }
            if (eligibleFiles.size() == 0) {
                return new ImmutablePair((Object)Option.empty(), lastCheckpointStr.orElseGet(() -> String.valueOf(Long.MIN_VALUE)));
            }
            String pathStr = eligibleFiles.stream().map(f -> f.getPath().toString()).collect(Collectors.joining(","));
            return new ImmutablePair((Object)Option.ofNullable((Object)pathStr), (Object)String.valueOf(nextBatchId));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to readAvro from source from checkpoint: " + lastCheckpointStr, ioe);
        }
    }
}

