/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.integ.testsuite.reader;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.integ.testsuite.reader.DFSDeltaInputReader;
import org.apache.hudi.integ.testsuite.reader.SparkBasedReader;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.SparkSession;

public class DFSAvroDeltaInputReader
extends DFSDeltaInputReader {
    private final SparkSession sparkSession;
    private final String schemaStr;
    private final String basePath;
    private final Option<String> structName;
    private final Option<String> nameSpace;
    protected PathFilter filter = path -> path.toUri().toString().contains(".avro");

    public DFSAvroDeltaInputReader(SparkSession sparkSession, String schemaStr, String basePath, Option<String> structName, Option<String> nameSpace) {
        this.sparkSession = sparkSession;
        this.schemaStr = schemaStr;
        this.basePath = basePath;
        this.structName = structName;
        this.nameSpace = nameSpace;
    }

    @Override
    public JavaRDD<GenericRecord> read(long totalRecordsToRead) throws IOException {
        return SparkBasedReader.readAvro(this.sparkSession, this.schemaStr, this.getFilePathsToRead(this.basePath, this.filter, totalRecordsToRead), this.structName, this.nameSpace);
    }

    @Override
    public JavaRDD<GenericRecord> read(int numPartitions, long approxNumRecords) throws IOException {
        throw new UnsupportedOperationException("cannot generate updates");
    }

    @Override
    public JavaRDD<GenericRecord> read(int numPartitions, int numFiles, long approxNumRecords) throws IOException {
        throw new UnsupportedOperationException("cannot generate updates");
    }

    @Override
    public JavaRDD<GenericRecord> read(int numPartitions, int numFiles, double percentageRecordsPerFile) throws IOException {
        throw new UnsupportedOperationException("cannot generate updates");
    }

    @Override
    protected long analyzeSingleFile(String filePath) {
        JavaRDD<GenericRecord> recordsFromOneFile = SparkBasedReader.readAvro(this.sparkSession, this.schemaStr, Arrays.asList(filePath), this.structName, this.nameSpace);
        return recordsFromOneFile.count();
    }
}

