/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringUtils {
    private static final String[] STRINGS = new String[]{"This", "is", "a", "test"};

    @Test
    public void testStringJoinWithDelim() {
        String joinedString = StringUtils.joinUsingDelim((String)"-", (String[])STRINGS);
        Assertions.assertEquals((int)STRINGS.length, (int)joinedString.split("-").length);
    }

    @Test
    public void testStringJoin() {
        Assertions.assertNotEquals(null, (Object)StringUtils.join((String[])new String[]{""}));
        Assertions.assertNotEquals(null, (Object)StringUtils.join((String[])STRINGS));
    }

    @Test
    public void testStringJoinWithJavaImpl() {
        Assertions.assertNull((Object)StringUtils.join((CharSequence)",", null));
        Assertions.assertEquals((Object)"", (Object)String.join((CharSequence)",", Collections.singletonList("")));
        Assertions.assertEquals((Object)",", (Object)String.join((CharSequence)",", Arrays.asList("", "")));
        Assertions.assertEquals((Object)"a,", (Object)String.join((CharSequence)",", Arrays.asList("a", "")));
    }

    @Test
    public void testStringNullToEmpty() {
        String str = "This is a test";
        Assertions.assertEquals((Object)str, (Object)StringUtils.nullToEmpty((String)str));
        Assertions.assertEquals((Object)"", (Object)StringUtils.nullToEmpty(null));
    }

    @Test
    public void testStringObjToString() {
        Assertions.assertNull((Object)StringUtils.objToString(null));
        Assertions.assertEquals((Object)"Test String", (Object)StringUtils.objToString((Object)"Test String"));
        ByteBuffer byteBuffer1 = ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"1234"));
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"5678"));
        Assertions.assertEquals((Object)byteBuffer1.toString(), (Object)byteBuffer2.toString());
        Assertions.assertNotEquals((Object)StringUtils.objToString((Object)byteBuffer1), (Object)StringUtils.objToString((Object)byteBuffer2));
    }

    @Test
    public void testStringEmptyToNull() {
        Assertions.assertNull((Object)StringUtils.emptyToNull((String)""));
        Assertions.assertEquals((Object)"Test String", (Object)StringUtils.emptyToNull((String)"Test String"));
    }

    @Test
    public void testStringNullOrEmpty() {
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty(null));
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty((String)""));
        Assertions.assertNotEquals(null, (Object)StringUtils.isNullOrEmpty((String)"this is not empty"));
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty((String)""));
    }

    @Test
    public void testSplit() {
        Assertions.assertEquals(new ArrayList(), (Object)StringUtils.split(null, (String)","));
        Assertions.assertEquals(new ArrayList(), (Object)StringUtils.split((String)"", (String)","));
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)StringUtils.split((String)"a,b, c", (String)","));
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)StringUtils.split((String)"a,b,, c ", (String)","));
    }

    @Test
    public void testHexString() {
        String str = "abcd";
        Assertions.assertEquals((Object)StringUtils.toHexString((byte[])StringUtils.getUTF8Bytes((String)str)), (Object)TestStringUtils.toHexString(StringUtils.getUTF8Bytes((String)str)));
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    @Test
    public void testTruncate() {
        Assertions.assertNull((Object)StringUtils.truncate(null, (int)10, (int)10));
        Assertions.assertEquals((Object)"http://use...ons/latest", (Object)StringUtils.truncate((String)"http://username:password@myregistry.com:5000/versions/latest", (int)10, (int)10));
        Assertions.assertEquals((Object)"http://abc.com", (Object)StringUtils.truncate((String)"http://abc.com", (int)10, (int)10));
    }

    @Test
    public void testCompareVersions() {
        Assertions.assertTrue((StringUtils.compareVersions((String)"1.10", (String)"1.9") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareVersions((String)"1.9", (String)"1.10") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareVersions((String)"1.100.1", (String)"1.10") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareVersions((String)"1.10.1", (String)"1.10") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((StringUtils.compareVersions((String)"1.10", (String)"1.10") == 0 ? 1 : 0) != 0);
    }
}

