/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStoragePathFilter {
    @Test
    public void testFilter() {
        StoragePath path1 = new StoragePath("/x/y/1");
        StoragePath path2 = new StoragePath("/x/y/2");
        StoragePath path3 = new StoragePath("/x/z/1");
        StoragePath path4 = new StoragePath("/x/z/2");
        List pathList = Arrays.stream(new StoragePath[]{path1, path2, path3, path4}).collect(Collectors.toList());
        List expected = Arrays.stream(new StoragePath[]{path1, path2}).collect(Collectors.toList());
        Assertions.assertEquals(expected.stream().sorted().collect(Collectors.toList()), pathList.stream().filter(e -> new StoragePathFilter(){

            public boolean accept(StoragePath path) {
                return path.getParent().equals((Object)new StoragePath("/x/y"));
            }
        }.accept((StoragePath)e)).sorted().collect(Collectors.toList()));
        Assertions.assertEquals(pathList, pathList.stream().filter(e -> new StoragePathFilter(){

            public boolean accept(StoragePath path) {
                return true;
            }
        }.accept((StoragePath)e)).sorted().collect(Collectors.toList()));
    }
}

