/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress.airlift;

import io.airlift.compress.gzip.JdkGzipHadoopStreams;
import io.airlift.compress.hadoop.HadoopInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hudi.io.compress.HoodieDecompressor;
import org.apache.hudi.io.util.IOUtils;

public class HoodieAirliftGzipDecompressor
implements HoodieDecompressor {
    private final JdkGzipHadoopStreams gzipStreams = new JdkGzipHadoopStreams();

    @Override
    public int decompress(InputStream compressedInput, byte[] targetByteArray, int offset, int length) throws IOException {
        try (HadoopInputStream stream = this.gzipStreams.createInputStream(compressedInput);){
            int n = IOUtils.readFully((InputStream)stream, targetByteArray, offset, length);
            return n;
        }
    }
}

