/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHFileReader {
    public static final String SIMPLE_SCHEMA_HFILE_SUFFIX = "_simple.hfile";
    public static final String COMPLEX_SCHEMA_HFILE_SUFFIX = "_complex.hfile";
    public static final String BOOTSTRAP_INDEX_HFILE_SUFFIX = "_bootstrap_index_partitions.hfile";
    public static final String CUSTOM_META_KEY = "hudi_hfile_testing.custom_key";
    public static final String CUSTOM_META_VALUE = "hudi_custom_value";
    public static final String DUMMY_BLOOM_FILTER = "/////wAAABQBAAABID797Rg6cC9QEnS/mT3C01cdQGaLYH2jbOCLtMA0RWppEH1HQg==";
    public static final Function<Integer, String> KEY_CREATOR = i -> String.format("hudi-key-%09d", i);
    public static final Function<Integer, String> VALUE_CREATOR = i -> String.format("hudi-value-%09d", i);
    private static final int SEEK_TO_THROW_EXCEPTION = -2;

    static Stream<Arguments> testArgsReadHFilePointAndPrefixLookup() {
        return Stream.of(Arguments.of((Object[])new Object[]{"/hfile/hudi_1_0_hbase_2_4_9_16KB_GZ_20000.hfile", 20000, Arrays.asList(new KeyLookUpInfo("", -1, "", ""), new KeyLookUpInfo("a", -1, "", ""), new KeyLookUpInfo("hudi-key-0000000", -1, "", ""), new KeyLookUpInfo("hudi-key-000000000", 0, "hudi-key-000000000", "hudi-value-000000000"), new KeyLookUpInfo("hudi-key-000000100", 0, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000099", -2, "", ""), new KeyLookUpInfo("hudi-key-000000100a", 1, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000100b", 1, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000200a", 1, "hudi-key-000000200", "hudi-value-000000200"), new KeyLookUpInfo("hudi-key-000000200b", 1, "hudi-key-000000200", "hudi-value-000000200"), new KeyLookUpInfo("hudi-key-000000277", 0, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000277a", 1, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000277b", 1, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000278", 0, "hudi-key-000000278", "hudi-value-000000278"), new KeyLookUpInfo("hudi-key-000002501a", 1, "hudi-key-000002501", "hudi-value-000002501"), new KeyLookUpInfo("hudi-key-000002501b", 1, "hudi-key-000002501", "hudi-value-000002501"), new KeyLookUpInfo("hudi-key-000008340", 0, "hudi-key-000008340", "hudi-value-000008340"), new KeyLookUpInfo("hudi-key-000013899", 0, "hudi-key-000013899", "hudi-value-000013899"), new KeyLookUpInfo("hudi-key-000013899", 0, "hudi-key-000013899", "hudi-value-000013899"), new KeyLookUpInfo("hudi-key-000013900", 0, "hudi-key-000013900", "hudi-value-000013900"), new KeyLookUpInfo("hudi-key-000013901", 0, "hudi-key-000013901", "hudi-value-000013901"), new KeyLookUpInfo("hudi-key-000013902", 0, "hudi-key-000013902", "hudi-value-000013902"), new KeyLookUpInfo("hudi-key-000019500", 0, "hudi-key-000019500", "hudi-value-000019500"), new KeyLookUpInfo("hudi-key-0000196", 1, "hudi-key-000019599", "hudi-value-000019599"), new KeyLookUpInfo("hudi-key-00001960", 1, "hudi-key-000019599", "hudi-value-000019599"), new KeyLookUpInfo("hudi-key-000019600a", 1, "hudi-key-000019600", "hudi-value-000019600"), new KeyLookUpInfo("hudi-key-000019998", 0, "hudi-key-000019998", "hudi-value-000019998"), new KeyLookUpInfo("hudi-key-000019999", 0, "hudi-key-000019999", "hudi-value-000019999"), new KeyLookUpInfo("hudi-key-000019999a", 2, "", ""), new KeyLookUpInfo("hudi-key-000019999b", 2, "", ""))}), Arguments.of((Object[])new Object[]{"/hfile/hudi_1_0_hbase_2_4_9_512KB_GZ_20000.hfile", 20000, Arrays.asList(new KeyLookUpInfo("", -1, "", ""), new KeyLookUpInfo("a", -1, "", ""), new KeyLookUpInfo("hudi-key-0000000", -1, "", ""), new KeyLookUpInfo("hudi-key-000000000", 0, "hudi-key-000000000", "hudi-value-000000000"), new KeyLookUpInfo("hudi-key-000008886", 0, "hudi-key-000008886", "hudi-value-000008886"), new KeyLookUpInfo("hudi-key-000008886a", 1, "hudi-key-000008886", "hudi-value-000008886"), new KeyLookUpInfo("hudi-key-000008886b", 1, "hudi-key-000008886", "hudi-value-000008886"), new KeyLookUpInfo("hudi-key-000008888", 0, "hudi-key-000008888", "hudi-value-000008888"), new KeyLookUpInfo("hudi-key-000008889", 0, "hudi-key-000008889", "hudi-value-000008889"), new KeyLookUpInfo("hudi-key-000008890", 0, "hudi-key-000008890", "hudi-value-000008890"), new KeyLookUpInfo("hudi-key-0000090", 1, "hudi-key-000008999", "hudi-value-000008999"), new KeyLookUpInfo("hudi-key-00000900", 1, "hudi-key-000008999", "hudi-value-000008999"), new KeyLookUpInfo("hudi-key-000009000a", 1, "hudi-key-000009000", "hudi-value-000009000"), new KeyLookUpInfo("hudi-key-000017773", 0, "hudi-key-000017773", "hudi-value-000017773"), new KeyLookUpInfo("hudi-key-000020000", 2, "", ""), new KeyLookUpInfo("hudi-key-000020001", 2, "", ""))}), Arguments.of((Object[])new Object[]{"/hfile/hudi_1_0_hbase_2_4_9_16KB_NONE_5000.hfile", 5000, Arrays.asList(new KeyLookUpInfo("", -1, "", ""), new KeyLookUpInfo("a", -1, "", ""), new KeyLookUpInfo("hudi-key-0000000", -1, "", ""), new KeyLookUpInfo("hudi-key-000000000", 0, "hudi-key-000000000", "hudi-value-000000000"), new KeyLookUpInfo("hudi-key-000000100", 0, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000099", -2, "", ""), new KeyLookUpInfo("hudi-key-000000100a", 1, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000100b", 1, "hudi-key-000000100", "hudi-value-000000100"), new KeyLookUpInfo("hudi-key-000000200a", 1, "hudi-key-000000200", "hudi-value-000000200"), new KeyLookUpInfo("hudi-key-000000200b", 1, "hudi-key-000000200", "hudi-value-000000200"), new KeyLookUpInfo("hudi-key-000000277", 0, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000277a", 1, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000277b", 1, "hudi-key-000000277", "hudi-value-000000277"), new KeyLookUpInfo("hudi-key-000000278", 0, "hudi-key-000000278", "hudi-value-000000278"), new KeyLookUpInfo("hudi-key-000002501a", 1, "hudi-key-000002501", "hudi-value-000002501"), new KeyLookUpInfo("hudi-key-000002501b", 1, "hudi-key-000002501", "hudi-value-000002501"), new KeyLookUpInfo("hudi-key-000003336", 0, "hudi-key-000003336", "hudi-value-000003336"), new KeyLookUpInfo("hudi-key-000004169", 0, "hudi-key-000004169", "hudi-value-000004169"), new KeyLookUpInfo("hudi-key-000004169", 0, "hudi-key-000004169", "hudi-value-000004169"), new KeyLookUpInfo("hudi-key-000004600", 0, "hudi-key-000004600", "hudi-value-000004600"), new KeyLookUpInfo("hudi-key-000004601", 0, "hudi-key-000004601", "hudi-value-000004601"), new KeyLookUpInfo("hudi-key-000004602", 0, "hudi-key-000004602", "hudi-value-000004602"), new KeyLookUpInfo("hudi-key-0000047", 1, "hudi-key-000004699", "hudi-value-000004699"), new KeyLookUpInfo("hudi-key-00000470", 1, "hudi-key-000004699", "hudi-value-000004699"), new KeyLookUpInfo("hudi-key-000004700a", 1, "hudi-key-000004700", "hudi-value-000004700"), new KeyLookUpInfo("hudi-key-000004998", 0, "hudi-key-000004998", "hudi-value-000004998"), new KeyLookUpInfo("hudi-key-000004999", 0, "hudi-key-000004999", "hudi-value-000004999"), new KeyLookUpInfo("hudi-key-000004999a", 2, "", ""), new KeyLookUpInfo("hudi-key-000004999b", 2, "", ""))}), Arguments.of((Object[])new Object[]{"/hfile/hudi_1_0_hbase_2_4_9_64KB_NONE_5000.hfile", 5000, Arrays.asList(new KeyLookUpInfo("", -1, "", ""), new KeyLookUpInfo("a", -1, "", ""), new KeyLookUpInfo("hudi-key-0000000", -1, "", ""), new KeyLookUpInfo("hudi-key-000000000", 0, "hudi-key-000000000", "hudi-value-000000000"), new KeyLookUpInfo("hudi-key-000001110", 0, "hudi-key-000001110", "hudi-value-000001110"), new KeyLookUpInfo("hudi-key-000001110a", 1, "hudi-key-000001110", "hudi-value-000001110"), new KeyLookUpInfo("hudi-key-000001110b", 1, "hudi-key-000001110", "hudi-value-000001110"), new KeyLookUpInfo("hudi-key-000001688", 0, "hudi-key-000001688", "hudi-value-000001688"), new KeyLookUpInfo("hudi-key-000001689", 0, "hudi-key-000001689", "hudi-value-000001689"), new KeyLookUpInfo("hudi-key-000001690", 0, "hudi-key-000001690", "hudi-value-000001690"), new KeyLookUpInfo("hudi-key-0000023", 1, "hudi-key-000002299", "hudi-value-000002299"), new KeyLookUpInfo("hudi-key-00000230", 1, "hudi-key-000002299", "hudi-value-000002299"), new KeyLookUpInfo("hudi-key-000002300a", 1, "hudi-key-000002300", "hudi-value-000002300"), new KeyLookUpInfo("hudi-key-000003332", 0, "hudi-key-000003332", "hudi-value-000003332"), new KeyLookUpInfo("hudi-key-000020000", 2, "", ""), new KeyLookUpInfo("hudi-key-000020001", 2, "", ""))}));
    }

    @ParameterizedTest
    @MethodSource(value={"testArgsReadHFilePointAndPrefixLookup"})
    public void testReadHFilePointAndPrefixLookup(String filename, int numEntries, List<KeyLookUpInfo> keyLookUpInfoList) throws IOException {
        TestHFileReader.verifyHFileRead(filename, numEntries, KEY_CREATOR, VALUE_CREATOR, keyLookUpInfoList);
    }

    @Test
    public void testReadHFileWithNonUniqueKeys() throws IOException {
        try (HFileReader reader = TestHFileReader.getHFileReader("/hfile/hudi_1_0_hbase_2_4_9_16KB_GZ_200_20_non_unique.hfile");){
            int i;
            reader.initializeMetadata();
            TestHFileReader.verifyHFileMetadata(reader, 4200);
            Assertions.assertFalse((boolean)reader.isSeeked());
            Assertions.assertFalse((boolean)reader.next());
            Assertions.assertTrue((boolean)reader.seekTo());
            int numKeys = 200;
            for (i = 0; i < numKeys; ++i) {
                Option keyValue = reader.getKeyValue();
                Assertions.assertTrue((boolean)keyValue.isPresent());
                UTF8StringKey expectedKey = new UTF8StringKey(KEY_CREATOR.apply(i));
                String value = VALUE_CREATOR.apply(i);
                Assertions.assertEquals((Object)expectedKey, (Object)((KeyValue)keyValue.get()).getKey());
                Assertions.assertEquals((Object)value, (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
                Assertions.assertTrue((boolean)reader.next());
                for (int j = 0; j < 20; ++j) {
                    keyValue = reader.getKeyValue();
                    Assertions.assertTrue((boolean)keyValue.isPresent());
                    Assertions.assertEquals((Object)expectedKey, (Object)((KeyValue)keyValue.get()).getKey());
                    Assertions.assertEquals((Object)(value + "_" + j), (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
                    if (i == numKeys - 1 && j == 19) {
                        Assertions.assertFalse((boolean)reader.next());
                        continue;
                    }
                    Assertions.assertTrue((boolean)reader.next());
                }
            }
            Assertions.assertTrue((boolean)reader.seekTo());
            for (i = 0; i < numKeys; ++i) {
                String value;
                Option keyValue;
                int j;
                UTF8StringKey expectedKey = new UTF8StringKey(KEY_CREATOR.apply(i));
                for (j = 0; j < 1; ++j) {
                    Assertions.assertEquals((int)0, (int)reader.seekTo((Key)expectedKey));
                    keyValue = reader.getKeyValue();
                    Assertions.assertTrue((boolean)keyValue.isPresent());
                    value = VALUE_CREATOR.apply(i);
                    Assertions.assertEquals((Object)expectedKey, (Object)((KeyValue)keyValue.get()).getKey());
                    Assertions.assertEquals((Object)value, (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
                }
                Assertions.assertTrue((boolean)reader.next());
                for (j = 0; j < 1; ++j) {
                    Assertions.assertEquals((int)0, (int)reader.seekTo((Key)expectedKey));
                    keyValue = reader.getKeyValue();
                    Assertions.assertTrue((boolean)keyValue.isPresent());
                    value = VALUE_CREATOR.apply(i);
                    Assertions.assertEquals((Object)expectedKey, (Object)((KeyValue)keyValue.get()).getKey());
                    Assertions.assertEquals((Object)(value + "_0"), (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
                }
            }
            TestHFileReader.verifyHFileSeekToReads(reader, Arrays.asList(new KeyLookUpInfo("", -1, "", ""), new KeyLookUpInfo("a", -1, "", ""), new KeyLookUpInfo("hudi-key-0000000", -1, "", ""), new KeyLookUpInfo("hudi-key-000000000", 0, "hudi-key-000000000", "hudi-value-000000000"), new KeyLookUpInfo("hudi-key-000000005", 0, "hudi-key-000000005", "hudi-value-000000005"), new KeyLookUpInfo("hudi-key-000000004", -2, "", ""), new KeyLookUpInfo("hudi-key-000000006a", 1, "hudi-key-000000006", "hudi-value-000000006_19"), new KeyLookUpInfo("hudi-key-000000006b", 1, "hudi-key-000000006", "hudi-value-000000006_19"), new KeyLookUpInfo("hudi-key-000000008a", 1, "hudi-key-000000008", "hudi-value-000000008_19"), new KeyLookUpInfo("hudi-key-000000008b", 1, "hudi-key-000000008", "hudi-value-000000008_19"), new KeyLookUpInfo("hudi-key-000000012", 0, "hudi-key-000000012", "hudi-value-000000012"), new KeyLookUpInfo("hudi-key-000000012a", 1, "hudi-key-000000012", "hudi-value-000000012_19"), new KeyLookUpInfo("hudi-key-000000012b", 1, "hudi-key-000000012", "hudi-value-000000012_19"), new KeyLookUpInfo("hudi-key-000000013", 0, "hudi-key-000000013", "hudi-value-000000013"), new KeyLookUpInfo("hudi-key-000000064a", 1, "hudi-key-000000064", "hudi-value-000000064_19"), new KeyLookUpInfo("hudi-key-000000064b", 1, "hudi-key-000000064", "hudi-value-000000064_19"), new KeyLookUpInfo("hudi-key-000000104", 0, "hudi-key-000000104", "hudi-value-000000104"), new KeyLookUpInfo("hudi-key-000000155", 0, "hudi-key-000000155", "hudi-value-000000155"), new KeyLookUpInfo("hudi-key-000000155", 0, "hudi-key-000000155", "hudi-value-000000155"), new KeyLookUpInfo("hudi-key-000000156", 0, "hudi-key-000000156", "hudi-value-000000156"), new KeyLookUpInfo("hudi-key-000000157", 0, "hudi-key-000000157", "hudi-value-000000157"), new KeyLookUpInfo("hudi-key-000000158", 0, "hudi-key-000000158", "hudi-value-000000158"), new KeyLookUpInfo("hudi-key-00000019", 1, "hudi-key-000000189", "hudi-value-000000189_19"), new KeyLookUpInfo("hudi-key-000000190a", 1, "hudi-key-000000190", "hudi-value-000000190_19"), new KeyLookUpInfo("hudi-key-000000198", 0, "hudi-key-000000198", "hudi-value-000000198"), new KeyLookUpInfo("hudi-key-000000199", 0, "hudi-key-000000199", "hudi-value-000000199"), new KeyLookUpInfo("hudi-key-000000199a", 2, "", ""), new KeyLookUpInfo("hudi-key-000000199b", 2, "", "")));
        }
    }

    @Test
    public void testReadHFileWithoutKeyValueEntries() throws IOException {
        try (HFileReader reader = TestHFileReader.getHFileReader("/hfile/hudi_1_0_hbase_2_4_9_no_entry.hfile");){
            reader.initializeMetadata();
            TestHFileReader.verifyHFileMetadataCompatibility(reader, 0);
            Assertions.assertFalse((boolean)reader.isSeeked());
            Assertions.assertFalse((boolean)reader.next());
            Assertions.assertFalse((boolean)reader.seekTo());
            Assertions.assertFalse((boolean)reader.next());
            Assertions.assertEquals((int)2, (int)reader.seekTo((Key)new UTF8StringKey("random")));
            Assertions.assertFalse((boolean)reader.next());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"/hfile/hudi_0_9_hbase_1_2_3", "/hfile/hudi_0_10_hbase_1_2_3", "/hfile/hudi_0_11_hbase_2_4_9"})
    public void testReadHFileCompatibility(String hfilePrefix) throws IOException {
        String simpleHFile = hfilePrefix + SIMPLE_SCHEMA_HFILE_SUFFIX;
        String complexHFile = hfilePrefix + COMPLEX_SCHEMA_HFILE_SUFFIX;
        String bootstrapIndexFile = hfilePrefix + BOOTSTRAP_INDEX_HFILE_SUFFIX;
        Option keyCreator = Option.of(i -> "key" + String.format("%02d", i));
        TestHFileReader.verifyHFileReadCompatibility(simpleHFile, 50, (Option<Function<Integer, String>>)keyCreator);
        TestHFileReader.verifyHFileReadCompatibility(complexHFile, 50, (Option<Function<Integer, String>>)keyCreator);
        TestHFileReader.verifyHFileReadCompatibility(bootstrapIndexFile, 4, (Option<Function<Integer, String>>)Option.empty());
    }

    public static byte[] readHFileFromResources(String filename) throws IOException {
        long size = TestHFileReader.class.getResource(filename).openConnection().getContentLength();
        return FileIOUtils.readAsByteArray((InputStream)TestHFileReader.class.getResourceAsStream(filename), (int)((int)size));
    }

    public static HFileReader getHFileReader(String filename) throws IOException {
        byte[] content = TestHFileReader.readHFileFromResources(filename);
        return new HFileReaderImpl((SeekableDataInputStream)new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream(content)), (long)content.length);
    }

    private static void verifyHFileRead(String filename, int numEntries, Function<Integer, String> keyCreator, Function<Integer, String> valueCreator, List<KeyLookUpInfo> keyLookUpInfoList) throws IOException {
        try (HFileReader reader = TestHFileReader.getHFileReader(filename);){
            reader.initializeMetadata();
            TestHFileReader.verifyHFileMetadata(reader, numEntries);
            TestHFileReader.verifyHFileValuesInSequentialReads(reader, numEntries, (Option<Function<Integer, String>>)Option.of(keyCreator), (Option<Function<Integer, String>>)Option.of(valueCreator));
            TestHFileReader.verifyHFileSeekToReads(reader, keyLookUpInfoList);
        }
    }

    private static void verifyHFileMetadata(HFileReader reader, int numEntries) throws IOException {
        Assertions.assertEquals((long)numEntries, (long)reader.getNumKeyValueEntries());
        Option customValue = reader.getMetaInfo(new UTF8StringKey(CUSTOM_META_KEY));
        Assertions.assertTrue((boolean)customValue.isPresent());
        Assertions.assertEquals((Object)CUSTOM_META_VALUE, (Object)new String((byte[])customValue.get(), StandardCharsets.UTF_8));
        Option bloomFilter = reader.getMetaBlock("bloomFilter");
        Assertions.assertTrue((boolean)bloomFilter.isPresent());
        Assertions.assertEquals((Object)DUMMY_BLOOM_FILTER, (Object)new String(((ByteBuffer)bloomFilter.get()).array(), ((ByteBuffer)bloomFilter.get()).position(), ((ByteBuffer)bloomFilter.get()).remaining(), StandardCharsets.UTF_8));
    }

    private static void verifyHFileReadCompatibility(String filename, int numEntries, Option<Function<Integer, String>> keyCreator) throws IOException {
        try (HFileReader reader = TestHFileReader.getHFileReader(filename);){
            reader.initializeMetadata();
            TestHFileReader.verifyHFileMetadataCompatibility(reader, numEntries);
            TestHFileReader.verifyHFileValuesInSequentialReads(reader, numEntries, keyCreator);
        }
    }

    private static void verifyHFileMetadataCompatibility(HFileReader reader, int numEntries) {
        Assertions.assertEquals((long)numEntries, (long)reader.getNumKeyValueEntries());
    }

    private static void verifyHFileValuesInSequentialReads(HFileReader reader, int numEntries, Option<Function<Integer, String>> keyCreator) throws IOException {
        TestHFileReader.verifyHFileValuesInSequentialReads(reader, numEntries, keyCreator, (Option<Function<Integer, String>>)Option.empty());
    }

    private static void verifyHFileValuesInSequentialReads(HFileReader reader, int numEntries, Option<Function<Integer, String>> keyCreator, Option<Function<Integer, String>> valueCreator) throws IOException {
        int i;
        Assertions.assertFalse((boolean)reader.isSeeked());
        Assertions.assertFalse((boolean)reader.next());
        boolean result = reader.seekTo();
        Assertions.assertEquals((Object)(numEntries > 0 ? 1 : 0), (Object)result);
        for (i = 0; i < numEntries; ++i) {
            Option keyValue = reader.getKeyValue();
            Assertions.assertTrue((boolean)keyValue.isPresent());
            if (keyCreator.isPresent()) {
                Assertions.assertEquals((Object)new UTF8StringKey((String)((Function)keyCreator.get()).apply(i)), (Object)((KeyValue)keyValue.get()).getKey());
            }
            if (valueCreator.isPresent()) {
                Assertions.assertEquals(((Function)valueCreator.get()).apply(i), (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
            }
            if (i < numEntries - 1) {
                Assertions.assertTrue((boolean)reader.next());
                continue;
            }
            Assertions.assertFalse((boolean)reader.next());
        }
        if (keyCreator.isPresent()) {
            result = reader.seekTo();
            Assertions.assertEquals((Object)(numEntries > 0 ? 1 : 0), (Object)result);
            for (i = 0; i < numEntries; ++i) {
                UTF8StringKey expecedKey = new UTF8StringKey((String)((Function)keyCreator.get()).apply(i));
                Assertions.assertEquals((int)0, (int)reader.seekTo((Key)expecedKey));
                Option keyValue = reader.getKeyValue();
                Assertions.assertTrue((boolean)keyValue.isPresent());
                Assertions.assertEquals((Object)expecedKey, (Object)((KeyValue)keyValue.get()).getKey());
                if (!valueCreator.isPresent()) continue;
                Assertions.assertEquals(((Function)valueCreator.get()).apply(i), (Object)HFileUtils.getValue((KeyValue)((KeyValue)keyValue.get())));
            }
        }
    }

    private static void verifyHFileSeekToReads(HFileReader reader, List<KeyLookUpInfo> keyLookUpInfoList) throws IOException {
        Assertions.assertTrue((boolean)reader.seekTo());
        block5: for (KeyLookUpInfo keyLookUpInfo : keyLookUpInfoList) {
            int expectedSeekToResult = keyLookUpInfo.getExpectedSeekToResult();
            if (expectedSeekToResult == -2) {
                Assertions.assertThrows(IllegalStateException.class, () -> reader.seekTo((Key)new UTF8StringKey(keyLookUpInfo.getLookUpKey())));
            } else {
                Assertions.assertEquals((int)expectedSeekToResult, (int)reader.seekTo((Key)new UTF8StringKey(keyLookUpInfo.getLookUpKey())), (String)String.format("Unexpected seekTo result for lookup key %s", keyLookUpInfo.getLookUpKey()));
            }
            switch (expectedSeekToResult) {
                case -2: 
                case -1: {
                    continue block5;
                }
                case 0: 
                case 1: {
                    Assertions.assertTrue((boolean)reader.getKeyValue().isPresent());
                    Assertions.assertEquals((Object)new UTF8StringKey(keyLookUpInfo.getExpectedKey()), (Object)((KeyValue)reader.getKeyValue().get()).getKey());
                    Assertions.assertEquals((Object)keyLookUpInfo.getExpectedValue(), (Object)HFileUtils.getValue((KeyValue)((KeyValue)reader.getKeyValue().get())));
                    continue block5;
                }
                case 2: {
                    Assertions.assertFalse((boolean)reader.getKeyValue().isPresent());
                    Assertions.assertFalse((boolean)reader.next());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("SeekTo result not allowed: " + keyLookUpInfo.expectedSeekToResult);
        }
    }

    static class KeyLookUpInfo {
        private final String lookUpKey;
        private final int expectedSeekToResult;
        private final String expectedKey;
        private final String expectedValue;

        public KeyLookUpInfo(String lookUpKey, int expectedSeekToResult, String expectedKey, String expectedValue) {
            this.lookUpKey = lookUpKey;
            this.expectedSeekToResult = expectedSeekToResult;
            this.expectedKey = expectedKey;
            this.expectedValue = expectedValue;
        }

        public String getLookUpKey() {
            return this.lookUpKey;
        }

        public int getExpectedSeekToResult() {
            return this.expectedSeekToResult;
        }

        public String getExpectedKey() {
            return this.expectedKey;
        }

        public String getExpectedValue() {
            return this.expectedValue;
        }
    }
}

