/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStoragePathInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TestStoragePathInfo.class);
    private static final long LENGTH = 100L;
    private static final short BLOCK_REPLICATION = 1;
    private static final long BLOCK_SIZE = 1000000L;
    private static final long MODIFICATION_TIME = System.currentTimeMillis();
    private static final String PATH1 = "/abc/xyz1";
    private static final String PATH2 = "/abc/xyz2";
    private static final StoragePath STORAGE_PATH1 = new StoragePath("/abc/xyz1");
    private static final StoragePath STORAGE_PATH2 = new StoragePath("/abc/xyz2");

    @Test
    public void testConstructor() {
        StoragePathInfo pathInfo = new StoragePathInfo(STORAGE_PATH1, 100L, false, 1, 1000000L, MODIFICATION_TIME);
        this.validateAccessors(pathInfo, PATH1, 100L, false, MODIFICATION_TIME);
        pathInfo = new StoragePathInfo(STORAGE_PATH2, -1L, true, 1, 1000000L, MODIFICATION_TIME + 2L);
        this.validateAccessors(pathInfo, PATH2, -1L, true, MODIFICATION_TIME + 2L);
    }

    @Test
    public void testSerializability() throws IOException, ClassNotFoundException {
        StoragePathInfo pathInfo = new StoragePathInfo(STORAGE_PATH1, 100L, false, 1, 1000000L, MODIFICATION_TIME);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(pathInfo);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                StoragePathInfo deserialized = (StoragePathInfo)ois.readObject();
                this.validateAccessors(deserialized, PATH1, 100L, false, MODIFICATION_TIME);
            }
        }
    }

    @Test
    public void testCompareTo() {
        StoragePathInfo pathInfo1 = new StoragePathInfo(new StoragePath(PATH1), 100L, false, 1, 1000000L, MODIFICATION_TIME);
        StoragePathInfo pathInfo2 = new StoragePathInfo(new StoragePath(PATH1), 102L, false, 1, 1000000L, MODIFICATION_TIME + 2L);
        StoragePathInfo pathInfo3 = new StoragePathInfo(new StoragePath(PATH2), 100L, false, 1, 1000000L, MODIFICATION_TIME);
        Assertions.assertEquals((int)0, (int)pathInfo1.compareTo(pathInfo2));
        Assertions.assertEquals((int)-1, (int)pathInfo1.compareTo(pathInfo3));
    }

    @Test
    public void testEquals() {
        StoragePathInfo pathInfo1 = new StoragePathInfo(new StoragePath(PATH1), 100L, false, 1, 1000000L, MODIFICATION_TIME);
        StoragePathInfo pathInfo2 = new StoragePathInfo(new StoragePath(PATH1), 102L, false, 1, 1000000L, MODIFICATION_TIME + 2L);
        Assertions.assertEquals((Object)pathInfo1, (Object)pathInfo2);
    }

    @Test
    public void testNotEquals() {
        StoragePathInfo pathInfo1 = new StoragePathInfo(STORAGE_PATH1, 100L, false, 1, 1000000L, MODIFICATION_TIME);
        StoragePathInfo pathInfo2 = new StoragePathInfo(STORAGE_PATH2, 100L, false, 1, 1000000L, MODIFICATION_TIME + 2L);
        Assertions.assertFalse((boolean)pathInfo1.equals((Object)pathInfo2));
        Assertions.assertFalse((boolean)pathInfo2.equals((Object)pathInfo1));
    }

    private void validateAccessors(StoragePathInfo pathInfo, String path, long length, boolean isDirectory, long modificationTime) {
        Assertions.assertEquals((Object)new StoragePath(path), (Object)pathInfo.getPath());
        Assertions.assertEquals((long)length, (long)pathInfo.getLength());
        Assertions.assertEquals((Object)isDirectory, (Object)pathInfo.isDirectory());
        Assertions.assertEquals((Object)(!isDirectory ? 1 : 0), (Object)pathInfo.isFile());
        Assertions.assertEquals((long)modificationTime, (long)pathInfo.getModificationTime());
    }
}

