/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseTestStorageConfiguration<T> {
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>();
    private static final String KEY_STRING = "hudi.key.string";
    private static final String KEY_STRING_OTHER = "hudi.key.string.other";
    private static final String KEY_BOOLEAN = "hudi.key.boolean";
    private static final String KEY_LONG = "hudi.key.long";
    private static final String KEY_ENUM = "hudi.key.enum";
    private static final String KEY_NON_EXISTENT = "hudi.key.non_existent";
    private static final String VALUE_STRING = "string_value";
    private static final String VALUE_STRING_1 = "string_value_1";
    private static final String VALUE_BOOLEAN = "true";
    private static final String VALUE_LONG = "12309120";
    private static final String VALUE_ENUM = TestEnum.ENUM2.toString();

    protected abstract StorageConfiguration<T> getStorageConfiguration(T var1);

    protected abstract T getConf(Map<String, String> var1);

    @Test
    public void testConstructorNewInstanceUnwrapCopy() {
        T conf = this.getConf(this.prepareConfigs());
        StorageConfiguration storageConf = this.getStorageConfiguration(conf);
        StorageConfiguration newStorageConf = storageConf.newInstance();
        Class<?> unwrapperConfClass = storageConf.unwrap().getClass();
        Assertions.assertNotSame(storageConf, (Object)newStorageConf, (String)"storageConf.newInstance() should return a different StorageConfiguration instance.");
        this.validateConfigs(newStorageConf);
        Assertions.assertNotSame((Object)storageConf.unwrap(), (Object)newStorageConf.unwrap(), (String)"storageConf.newInstance() should contain a new copy of the underlying configuration instance.");
        Assertions.assertSame((Object)storageConf.unwrap(), (Object)storageConf.unwrap(), (String)"storageConf.unwrap() should return the same underlying configuration instance.");
        Assertions.assertSame((Object)storageConf.unwrap(), (Object)storageConf.unwrapAs(unwrapperConfClass), (String)"storageConf.unwrapAs(unwrapperConfClass) should return the same underlying configuration instance.");
        Assertions.assertNotSame((Object)storageConf.unwrap(), (Object)storageConf.unwrapCopy(), (String)"storageConf.unwrapCopy() should return a new copy of the underlying configuration instance.");
        this.validateConfigs(this.getStorageConfiguration(storageConf.unwrapCopy()));
        Assertions.assertNotSame((Object)storageConf.unwrap(), (Object)storageConf.unwrapCopyAs(unwrapperConfClass), (String)"storageConf.unwrapCopyAs(unwrapperConfClass) should return a new copy of the underlying configuration instance.");
        this.validateConfigs(this.getStorageConfiguration(storageConf.unwrapCopyAs(unwrapperConfClass)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Integer cfr_ignored_0 = (Integer)storageConf.unwrapAs(Integer.class);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Integer cfr_ignored_0 = (Integer)storageConf.unwrapCopyAs(Integer.class);
        });
    }

    @Test
    public void testSet() {
        StorageConfiguration<T> storageConf = this.getStorageConfiguration(this.getConf(EMPTY_MAP));
        Assertions.assertFalse((boolean)storageConf.getString(KEY_STRING).isPresent());
        Assertions.assertFalse((boolean)storageConf.getString(KEY_BOOLEAN).isPresent());
        storageConf.set(KEY_STRING, VALUE_STRING);
        storageConf.set(KEY_BOOLEAN, VALUE_BOOLEAN);
        Assertions.assertEquals((Object)Option.of((Object)VALUE_STRING), (Object)storageConf.getString(KEY_STRING));
        Assertions.assertTrue((boolean)storageConf.getBoolean(KEY_BOOLEAN, false));
        storageConf.setIfUnset(KEY_STRING, VALUE_STRING_1);
        storageConf.setIfUnset(KEY_STRING_OTHER, VALUE_STRING_1);
        Assertions.assertEquals((Object)Option.of((Object)VALUE_STRING), (Object)storageConf.getString(KEY_STRING));
        Assertions.assertEquals((Object)Option.of((Object)VALUE_STRING_1), (Object)storageConf.getString(KEY_STRING_OTHER));
    }

    @Test
    public void testGet() {
        StorageConfiguration<T> storageConf = this.getStorageConfiguration(this.getConf(this.prepareConfigs()));
        this.validateConfigs(storageConf);
    }

    @Test
    public void testSerializability() throws IOException, ClassNotFoundException {
        StorageConfiguration<T> storageConf = this.getStorageConfiguration(this.getConf(this.prepareConfigs()));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(storageConf);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                StorageConfiguration deserialized = (StorageConfiguration)ois.readObject();
                Assertions.assertNotNull((Object)deserialized.unwrap());
                this.validateConfigs(deserialized);
            }
        }
    }

    private Map<String, String> prepareConfigs() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put(KEY_STRING, VALUE_STRING);
        conf.put(KEY_BOOLEAN, VALUE_BOOLEAN);
        conf.put(KEY_LONG, VALUE_LONG);
        conf.put(KEY_ENUM, VALUE_ENUM);
        return conf;
    }

    private void validateConfigs(StorageConfiguration<?> storageConf) {
        Assertions.assertEquals((Object)Option.of((Object)VALUE_STRING), (Object)storageConf.getString(KEY_STRING));
        Assertions.assertEquals((Object)VALUE_STRING, (Object)storageConf.getString(KEY_STRING, ""));
        Assertions.assertTrue((boolean)storageConf.getBoolean(KEY_BOOLEAN, false));
        Assertions.assertFalse((boolean)storageConf.getBoolean(KEY_NON_EXISTENT, false));
        Assertions.assertEquals((long)Long.parseLong(VALUE_LONG), (long)storageConf.getLong(KEY_LONG, 0L));
        Assertions.assertEquals((long)30L, (long)storageConf.getLong(KEY_NON_EXISTENT, 30L));
        Assertions.assertEquals((Object)((Object)TestEnum.valueOf(VALUE_ENUM)), (Object)storageConf.getEnum(KEY_ENUM, (Enum)TestEnum.ENUM1));
        Assertions.assertEquals((Object)((Object)TestEnum.ENUM1), (Object)storageConf.getEnum(KEY_NON_EXISTENT, (Enum)TestEnum.ENUM1));
        Assertions.assertFalse((boolean)storageConf.getString(KEY_NON_EXISTENT).isPresent());
        Assertions.assertEquals((Object)VALUE_STRING, (Object)storageConf.getString(KEY_NON_EXISTENT, VALUE_STRING));
    }

    static enum TestEnum {
        ENUM1,
        ENUM2,
        ENUM3;

    }
}

